#
# Copyright 2013 Canonical Ltd.
#
# This file is part of python-ubuntu-platform-api.
#
# python-upa is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# python-upa is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup, Extension


sf_backend = Extension(name='upa._sf',
                    sources=['upa/_sf.cpp'],
                    include_dirs=['/usr/include/hybris'],
                    library_dirs=['/usr/lib/arm-linux-gnueabihf'],
                    libraries=[
                        'ubuntu_application_api',
                        'hybris_ics',
                        'EGL',
                        'GLESv2'
                        ]
                    )

mir_backend = Extension(name='upa._mir',
                    sources=['upa/_mir.cpp'],
                    include_dirs=['/usr/include/hybris'],
                    library_dirs=['/usr/lib/arm-linux-gnueabihf'],
                    libraries=[
                        'ubuntu_application_api_mirclient',
                        'hybris_ics',
                        'EGL',
                        'GLESv2'
                        ]
                    )

setup(
    name = 'UPA',
    version = '1.0',
    description = 'This is a demo package',
    ext_modules = [sf_backend, mir_backend],
    scripts=['monitor_upa'],
    packages=['upa'],
)
