# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._azure_machine_learning_workspaces_enums import *


class AssetJobInput(msrest.serialization.Model):
    """Asset input type.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. Input Asset URI.
    :vartype uri: str
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. Input Asset URI.
        :paramtype uri: str
        """
        super(AssetJobInput, self).__init__(**kwargs)
        self.mode = mode
        self.uri = uri


class AssetJobOutput(msrest.serialization.Model):
    """Asset output type.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI. This will have a default value of
     "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
    :vartype uri: str
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI. This will have a default value of
         "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
        :paramtype uri: str
        """
        super(AssetJobOutput, self).__init__(**kwargs)
        self.mode = mode
        self.uri = uri


class BatchJob(msrest.serialization.Model):
    """Batch endpoint job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compute: Compute configuration used to set instance count.
    :vartype compute: ~azure.mgmt.machinelearningservices.models.ComputeConfiguration
    :ivar dataset: Input dataset
     This will be deprecated. Use InputData instead.
    :vartype dataset: ~azure.mgmt.machinelearningservices.models.InferenceDataInputBase
    :ivar description: The asset description text.
    :vartype description: str
    :ivar error_threshold: Error threshold, if the error count for the entire input goes above this
     value,
     the batch inference will be aborted. Range is [-1, int.MaxValue]
     -1 value indicates, ignore all failures during batch inference.
    :vartype error_threshold: int
    :ivar input_data: Input data for the job.
    :vartype input_data: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
    :ivar interaction_endpoints: Dictonary of endpoint URIs, keyed by enumerated job endpoints.
    :vartype interaction_endpoints: dict[str,
     ~azure.mgmt.machinelearningservices.models.JobEndpoint]
    :ivar logging_level: Logging level for batch inference operation. Possible values include:
     "Info", "Warning", "Debug".
    :vartype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
    :ivar max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
    :vartype max_concurrency_per_instance: int
    :ivar mini_batch_size: Size of the mini-batch passed to each batch invocation.
     For FileDataset, this is the number of files per mini-batch.
     For TabularDataset, this is the size of the records in bytes, per mini-batch.
    :vartype mini_batch_size: long
    :ivar name:
    :vartype name: str
    :ivar output: Location of the job output logs and artifacts.
    :vartype output: ~azure.mgmt.machinelearningservices.models.JobOutputArtifacts
    :ivar output_data: Job output data location
     Optional parameter: when not specified, the default location is
     workspaceblobstore location.
    :vartype output_data: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutputV2]
    :ivar output_dataset: Output dataset location
     Optional parameter: when not specified, the default location is
     workspaceblobstore location.
     This will be deprecated. Use OutputData instead.
    :vartype output_dataset: ~azure.mgmt.machinelearningservices.models.DataVersion
    :ivar output_file_name: Output file name.
    :vartype output_file_name: str
    :ivar partition_keys: Partition keys list used for Named partitioning.
    :vartype partition_keys: list[str]
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar provisioning_state: Possible values include: "Succeeded", "Failed", "Canceled",
     "InProgress".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.JobProvisioningState
    :ivar retry_settings: Retry Settings for the batch inference operation.
    :vartype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
    :ivar status: Status of the job. Possible values include: "NotStarted", "Starting",
     "Provisioning", "Preparing", "Queued", "Running", "Finalizing", "CancelRequested", "Completed",
     "Failed", "Canceled", "NotResponding", "Paused", "Unknown".
    :vartype status: str or ~azure.mgmt.machinelearningservices.models.JobStatus
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'interaction_endpoints': {'readonly': True},
        'output': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'compute': {'key': 'compute', 'type': 'ComputeConfiguration'},
        'dataset': {'key': 'dataset', 'type': 'InferenceDataInputBase'},
        'description': {'key': 'description', 'type': 'str'},
        'error_threshold': {'key': 'errorThreshold', 'type': 'int'},
        'input_data': {'key': 'inputData', 'type': '{JobInput}'},
        'interaction_endpoints': {'key': 'interactionEndpoints', 'type': '{JobEndpoint}'},
        'logging_level': {'key': 'loggingLevel', 'type': 'str'},
        'max_concurrency_per_instance': {'key': 'maxConcurrencyPerInstance', 'type': 'int'},
        'mini_batch_size': {'key': 'miniBatchSize', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
        'output': {'key': 'output', 'type': 'JobOutputArtifacts'},
        'output_data': {'key': 'outputData', 'type': '{JobOutputV2}'},
        'output_dataset': {'key': 'outputDataset', 'type': 'DataVersion'},
        'output_file_name': {'key': 'outputFileName', 'type': 'str'},
        'partition_keys': {'key': 'partitionKeys', 'type': '[str]'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'retry_settings': {'key': 'retrySettings', 'type': 'BatchRetrySettings'},
        'status': {'key': 'status', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        compute: Optional["ComputeConfiguration"] = None,
        dataset: Optional["InferenceDataInputBase"] = None,
        description: Optional[str] = None,
        error_threshold: Optional[int] = None,
        input_data: Optional[Dict[str, "JobInput"]] = None,
        logging_level: Optional[Union[str, "BatchLoggingLevel"]] = None,
        max_concurrency_per_instance: Optional[int] = None,
        mini_batch_size: Optional[int] = None,
        name: Optional[str] = None,
        output_data: Optional[Dict[str, "JobOutputV2"]] = None,
        output_dataset: Optional["DataVersion"] = None,
        output_file_name: Optional[str] = None,
        partition_keys: Optional[List[str]] = None,
        properties: Optional[Dict[str, str]] = None,
        retry_settings: Optional["BatchRetrySettings"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword compute: Compute configuration used to set instance count.
        :paramtype compute: ~azure.mgmt.machinelearningservices.models.ComputeConfiguration
        :keyword dataset: Input dataset
         This will be deprecated. Use InputData instead.
        :paramtype dataset: ~azure.mgmt.machinelearningservices.models.InferenceDataInputBase
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword error_threshold: Error threshold, if the error count for the entire input goes above
         this value,
         the batch inference will be aborted. Range is [-1, int.MaxValue]
         -1 value indicates, ignore all failures during batch inference.
        :paramtype error_threshold: int
        :keyword input_data: Input data for the job.
        :paramtype input_data: dict[str, ~azure.mgmt.machinelearningservices.models.JobInput]
        :keyword logging_level: Logging level for batch inference operation. Possible values include:
         "Info", "Warning", "Debug".
        :paramtype logging_level: str or ~azure.mgmt.machinelearningservices.models.BatchLoggingLevel
        :keyword max_concurrency_per_instance: Indicates maximum number of parallelism per instance.
        :paramtype max_concurrency_per_instance: int
        :keyword mini_batch_size: Size of the mini-batch passed to each batch invocation.
         For FileDataset, this is the number of files per mini-batch.
         For TabularDataset, this is the size of the records in bytes, per mini-batch.
        :paramtype mini_batch_size: long
        :keyword name:
        :paramtype name: str
        :keyword output_data: Job output data location
         Optional parameter: when not specified, the default location is
         workspaceblobstore location.
        :paramtype output_data: dict[str, ~azure.mgmt.machinelearningservices.models.JobOutputV2]
        :keyword output_dataset: Output dataset location
         Optional parameter: when not specified, the default location is
         workspaceblobstore location.
         This will be deprecated. Use OutputData instead.
        :paramtype output_dataset: ~azure.mgmt.machinelearningservices.models.DataVersion
        :keyword output_file_name: Output file name.
        :paramtype output_file_name: str
        :keyword partition_keys: Partition keys list used for Named partitioning.
        :paramtype partition_keys: list[str]
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword retry_settings: Retry Settings for the batch inference operation.
        :paramtype retry_settings: ~azure.mgmt.machinelearningservices.models.BatchRetrySettings
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        """
        super(BatchJob, self).__init__(**kwargs)
        self.compute = compute
        self.dataset = dataset
        self.description = description
        self.error_threshold = error_threshold
        self.input_data = input_data
        self.interaction_endpoints = None
        self.logging_level = logging_level
        self.max_concurrency_per_instance = max_concurrency_per_instance
        self.mini_batch_size = mini_batch_size
        self.name = name
        self.output = None
        self.output_data = output_data
        self.output_dataset = output_dataset
        self.output_file_name = output_file_name
        self.partition_keys = partition_keys
        self.properties = properties
        self.provisioning_state = None
        self.retry_settings = retry_settings
        self.status = None
        self.tags = tags


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class BatchJobResource(Resource):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: Required. [Required] Additional attributes of the entity.
    :vartype properties: ~azure.mgmt.machinelearningservices.models.BatchJob
    :ivar system_data: System data associated with resource provider.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'BatchJob'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: "BatchJob",
        **kwargs
    ):
        """
        :keyword properties: Required. [Required] Additional attributes of the entity.
        :paramtype properties: ~azure.mgmt.machinelearningservices.models.BatchJob
        """
        super(BatchJobResource, self).__init__(**kwargs)
        self.properties = properties
        self.system_data = None


class BatchJobResourceArmPaginatedResult(msrest.serialization.Model):
    """A paginated list of BatchJob entities.

    :ivar next_link: The link to the next page of BatchJob objects. If null, there are no
     additional pages.
    :vartype next_link: str
    :ivar value: An array of objects of type BatchJob.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.BatchJobResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BatchJobResource]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["BatchJobResource"]] = None,
        **kwargs
    ):
        """
        :keyword next_link: The link to the next page of BatchJob objects. If null, there are no
         additional pages.
        :paramtype next_link: str
        :keyword value: An array of objects of type BatchJob.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.BatchJobResource]
        """
        super(BatchJobResourceArmPaginatedResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class BatchRetrySettings(msrest.serialization.Model):
    """Retry settings for a batch inference operation.

    :ivar max_retries: Maximum retry count for a mini-batch.
    :vartype max_retries: int
    :ivar timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
    :vartype timeout: ~datetime.timedelta
    """

    _attribute_map = {
        'max_retries': {'key': 'maxRetries', 'type': 'int'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
    }

    def __init__(
        self,
        *,
        max_retries: Optional[int] = None,
        timeout: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword max_retries: Maximum retry count for a mini-batch.
        :paramtype max_retries: int
        :keyword timeout: Invocation timeout for a mini-batch, in ISO 8601 format.
        :paramtype timeout: ~datetime.timedelta
        """
        super(BatchRetrySettings, self).__init__(**kwargs)
        self.max_retries = max_retries
        self.timeout = timeout


class ComputeConfiguration(msrest.serialization.Model):
    """Configuration for compute binding.

    :ivar instance_count: Number of instances or nodes.
    :vartype instance_count: int
    :ivar instance_type: SKU type to run on.
    :vartype instance_type: str
    :ivar is_local: Set to true for jobs running on local compute.
    :vartype is_local: bool
    :ivar location: Location for virtual cluster run.
    :vartype location: str
    :ivar properties: Additional properties.
    :vartype properties: dict[str, str]
    :ivar target: ARM resource ID of the Compute you are targeting. If not provided the resource
     will be deployed as Managed.
    :vartype target: str
    """

    _attribute_map = {
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'instance_type': {'key': 'instanceType', 'type': 'str'},
        'is_local': {'key': 'isLocal', 'type': 'bool'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        instance_count: Optional[int] = None,
        instance_type: Optional[str] = None,
        is_local: Optional[bool] = None,
        location: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword instance_count: Number of instances or nodes.
        :paramtype instance_count: int
        :keyword instance_type: SKU type to run on.
        :paramtype instance_type: str
        :keyword is_local: Set to true for jobs running on local compute.
        :paramtype is_local: bool
        :keyword location: Location for virtual cluster run.
        :paramtype location: str
        :keyword properties: Additional properties.
        :paramtype properties: dict[str, str]
        :keyword target: ARM resource ID of the Compute you are targeting. If not provided the resource
         will be deployed as Managed.
        :paramtype target: str
        """
        super(ComputeConfiguration, self).__init__(**kwargs)
        self.instance_count = instance_count
        self.instance_type = instance_type
        self.is_local = is_local
        self.location = location
        self.properties = properties
        self.target = target


class JobInput(msrest.serialization.Model):
    """Job input definition.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobInput, LiteralJobInput, MLFlowModelJobInput, MLTableJobInput, TritonModelJobInput, UriFileJobInput, UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_input_type': {'CustomModel': 'CustomModelJobInput', 'Literal': 'LiteralJobInput', 'MLFlowModel': 'MLFlowModelJobInput', 'MLTable': 'MLTableJobInput', 'TritonModel': 'TritonModelJobInput', 'UriFile': 'UriFileJobInput', 'UriFolder': 'UriFolderJobInput'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(JobInput, self).__init__(**kwargs)
        self.description = description
        self.job_input_type = None  # type: Optional[str]


class CustomModelJobInput(JobInput, AssetJobInput):
    """CustomModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(CustomModelJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'CustomModel'  # type: str
        self.description = description


class JobOutputV2(msrest.serialization.Model):
    """Job output definition container information on where to find the job output.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CustomModelJobOutput, MLFlowModelJobOutput, MLTableJobOutput, TritonModelJobOutput, UriFileJobOutput, UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "CustomModel", "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    _subtype_map = {
        'job_output_type': {'CustomModel': 'CustomModelJobOutput', 'MLFlowModel': 'MLFlowModelJobOutput', 'MLTable': 'MLTableJobOutput', 'TritonModel': 'TritonModelJobOutput', 'UriFile': 'UriFileJobOutput', 'UriFolder': 'UriFolderJobOutput'}
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(JobOutputV2, self).__init__(**kwargs)
        self.description = description
        self.job_output_type = None  # type: Optional[str]


class CustomModelJobOutput(JobOutputV2, AssetJobOutput):
    """CustomModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI. This will have a default value of
     "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "CustomModel", "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI. This will have a default value of
         "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(CustomModelJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'CustomModel'  # type: str
        self.description = description


class DataVersion(msrest.serialization.Model):
    """Data asset version details.

    All required parameters must be populated in order to send to Azure.

    :ivar dataset_type: The Format of dataset. Possible values include: "Simple", "Dataflow".
    :vartype dataset_type: str or ~azure.mgmt.machinelearningservices.models.DatasetType
    :ivar datastore_id: ARM resource ID of the datastore where the asset is located.
    :vartype datastore_id: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar is_anonymous: If the name version are system generated (anonymous registration).
    :vartype is_anonymous: bool
    :ivar path: Required. [Required] The path of the file/directory in the datastore.
    :vartype path: str
    :ivar properties: The asset property dictionary.
    :vartype properties: dict[str, str]
    :ivar tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'path': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'dataset_type': {'key': 'datasetType', 'type': 'str'},
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'is_anonymous': {'key': 'isAnonymous', 'type': 'bool'},
        'path': {'key': 'path', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        path: str,
        dataset_type: Optional[Union[str, "DatasetType"]] = None,
        datastore_id: Optional[str] = None,
        description: Optional[str] = None,
        is_anonymous: Optional[bool] = None,
        properties: Optional[Dict[str, str]] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword dataset_type: The Format of dataset. Possible values include: "Simple", "Dataflow".
        :paramtype dataset_type: str or ~azure.mgmt.machinelearningservices.models.DatasetType
        :keyword datastore_id: ARM resource ID of the datastore where the asset is located.
        :paramtype datastore_id: str
        :keyword description: The asset description text.
        :paramtype description: str
        :keyword is_anonymous: If the name version are system generated (anonymous registration).
        :paramtype is_anonymous: bool
        :keyword path: Required. [Required] The path of the file/directory in the datastore.
        :paramtype path: str
        :keyword properties: The asset property dictionary.
        :paramtype properties: dict[str, str]
        :keyword tags: A set of tags. Tag dictionary. Tags can be added, removed, and updated.
        :paramtype tags: dict[str, str]
        """
        super(DataVersion, self).__init__(**kwargs)
        self.dataset_type = dataset_type
        self.datastore_id = datastore_id
        self.description = description
        self.is_anonymous = is_anonymous
        self.path = path
        self.properties = properties
        self.tags = tags


class ErrorDetail(msrest.serialization.Model):
    """Error detail information.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Error code.
    :vartype code: str
    :ivar message: Required. Error message.
    :vartype message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        """
        :keyword code: Required. Error code.
        :paramtype code: str
        :keyword message: Required. Error message.
        :paramtype message: str
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponse(msrest.serialization.Model):
    """Error response information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar details: An array of error detail objects.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class InferenceDataInputBase(msrest.serialization.Model):
    """InferenceDataInputBase.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: InferenceDataUrlInput, InferenceDatasetIdInput, InferenceDatasetInput.

    All required parameters must be populated in order to send to Azure.

    :ivar data_input_type: Required. Constant filled by server. Possible values include:
     "DatasetVersion", "DatasetId", "DataUrl".
    :vartype data_input_type: str or
     ~azure.mgmt.machinelearningservices.models.InferenceDataInputType
    """

    _validation = {
        'data_input_type': {'required': True},
    }

    _attribute_map = {
        'data_input_type': {'key': 'dataInputType', 'type': 'str'},
    }

    _subtype_map = {
        'data_input_type': {'DataUrl': 'InferenceDataUrlInput', 'DatasetId': 'InferenceDatasetIdInput', 'DatasetVersion': 'InferenceDatasetInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(InferenceDataInputBase, self).__init__(**kwargs)
        self.data_input_type = None  # type: Optional[str]


class InferenceDatasetIdInput(InferenceDataInputBase):
    """InferenceDatasetIdInput.

    All required parameters must be populated in order to send to Azure.

    :ivar data_input_type: Required. Constant filled by server. Possible values include:
     "DatasetVersion", "DatasetId", "DataUrl".
    :vartype data_input_type: str or
     ~azure.mgmt.machinelearningservices.models.InferenceDataInputType
    :ivar dataset_id: ARM ID of the input dataset.
    :vartype dataset_id: str
    """

    _validation = {
        'data_input_type': {'required': True},
    }

    _attribute_map = {
        'data_input_type': {'key': 'dataInputType', 'type': 'str'},
        'dataset_id': {'key': 'datasetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dataset_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword dataset_id: ARM ID of the input dataset.
        :paramtype dataset_id: str
        """
        super(InferenceDatasetIdInput, self).__init__(**kwargs)
        self.data_input_type = 'DatasetId'  # type: str
        self.dataset_id = dataset_id


class InferenceDatasetInput(InferenceDataInputBase):
    """InferenceDatasetInput.

    All required parameters must be populated in order to send to Azure.

    :ivar data_input_type: Required. Constant filled by server. Possible values include:
     "DatasetVersion", "DatasetId", "DataUrl".
    :vartype data_input_type: str or
     ~azure.mgmt.machinelearningservices.models.InferenceDataInputType
    :ivar dataset_name: Name of the input dataset.
    :vartype dataset_name: str
    :ivar dataset_version: Version of the input dataset.
    :vartype dataset_version: str
    """

    _validation = {
        'data_input_type': {'required': True},
    }

    _attribute_map = {
        'data_input_type': {'key': 'dataInputType', 'type': 'str'},
        'dataset_name': {'key': 'datasetName', 'type': 'str'},
        'dataset_version': {'key': 'datasetVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dataset_name: Optional[str] = None,
        dataset_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword dataset_name: Name of the input dataset.
        :paramtype dataset_name: str
        :keyword dataset_version: Version of the input dataset.
        :paramtype dataset_version: str
        """
        super(InferenceDatasetInput, self).__init__(**kwargs)
        self.data_input_type = 'DatasetVersion'  # type: str
        self.dataset_name = dataset_name
        self.dataset_version = dataset_version


class InferenceDataUrlInput(InferenceDataInputBase):
    """InferenceDataUrlInput.

    All required parameters must be populated in order to send to Azure.

    :ivar data_input_type: Required. Constant filled by server. Possible values include:
     "DatasetVersion", "DatasetId", "DataUrl".
    :vartype data_input_type: str or
     ~azure.mgmt.machinelearningservices.models.InferenceDataInputType
    :ivar path: Required. Asset path to the input data, say a blob URL.
    :vartype path: str
    """

    _validation = {
        'data_input_type': {'required': True},
        'path': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'data_input_type': {'key': 'dataInputType', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: str,
        **kwargs
    ):
        """
        :keyword path: Required. Asset path to the input data, say a blob URL.
        :paramtype path: str
        """
        super(InferenceDataUrlInput, self).__init__(**kwargs)
        self.data_input_type = 'DataUrl'  # type: str
        self.path = path


class JobEndpoint(msrest.serialization.Model):
    """Job endpoint definition.

    :ivar endpoint: Url for endpoint.
    :vartype endpoint: str
    :ivar job_endpoint_type: Endpoint type.
    :vartype job_endpoint_type: str
    :ivar port: Port for endpoint.
    :vartype port: int
    :ivar properties: Additional properties to set on the endpoint.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
        'job_endpoint_type': {'key': 'jobEndpointType', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        endpoint: Optional[str] = None,
        job_endpoint_type: Optional[str] = None,
        port: Optional[int] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword endpoint: Url for endpoint.
        :paramtype endpoint: str
        :keyword job_endpoint_type: Endpoint type.
        :paramtype job_endpoint_type: str
        :keyword port: Port for endpoint.
        :paramtype port: int
        :keyword properties: Additional properties to set on the endpoint.
        :paramtype properties: dict[str, str]
        """
        super(JobEndpoint, self).__init__(**kwargs)
        self.endpoint = endpoint
        self.job_endpoint_type = job_endpoint_type
        self.port = port
        self.properties = properties


class JobOutputArtifacts(msrest.serialization.Model):
    """Job output definition container information on where to find job logs and artifacts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar datastore_id: ARM ID of the datastore where the job logs and artifacts are stored.
    :vartype datastore_id: str
    :ivar path: Path within the datastore to the job logs and artifacts.
    :vartype path: str
    """

    _validation = {
        'datastore_id': {'readonly': True},
        'path': {'readonly': True},
    }

    _attribute_map = {
        'datastore_id': {'key': 'datastoreId', 'type': 'str'},
        'path': {'key': 'path', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(JobOutputArtifacts, self).__init__(**kwargs)
        self.datastore_id = None
        self.path = None


class LabelClass(msrest.serialization.Model):
    """Label class definition.

    :ivar display_name: Display name of the label class.
    :vartype display_name: str
    :ivar subclasses: Dictionary of subclasses of the label class.
    :vartype subclasses: dict[str, ~azure.mgmt.machinelearningservices.models.LabelClass]
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'subclasses': {'key': 'subclasses', 'type': '{LabelClass}'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        subclasses: Optional[Dict[str, "LabelClass"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: Display name of the label class.
        :paramtype display_name: str
        :keyword subclasses: Dictionary of subclasses of the label class.
        :paramtype subclasses: dict[str, ~azure.mgmt.machinelearningservices.models.LabelClass]
        """
        super(LabelClass, self).__init__(**kwargs)
        self.display_name = display_name
        self.subclasses = subclasses


class LiteralJobInput(JobInput):
    """LiteralJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    :ivar value: Required. Literal input value.
    :vartype value: str
    """

    _validation = {
        'job_input_type': {'required': True},
        'value': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description for the input.
        :paramtype description: str
        :keyword value: Required. Literal input value.
        :paramtype value: str
        """
        super(LiteralJobInput, self).__init__(description=description, **kwargs)
        self.job_input_type = 'Literal'  # type: str
        self.value = value


class MLFlowModelJobInput(JobInput, AssetJobInput):
    """MLFlowModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLFlowModelJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'MLFlowModel'  # type: str
        self.description = description


class MLFlowModelJobOutput(JobOutputV2, AssetJobOutput):
    """MLFlowModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI. This will have a default value of
     "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "CustomModel", "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI. This will have a default value of
         "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLFlowModelJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'MLFlowModel'  # type: str
        self.description = description


class MLTableJobInput(JobInput, AssetJobInput):
    """MLTableJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(MLTableJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'MLTable'  # type: str
        self.description = description


class MLTableJobOutput(JobOutputV2, AssetJobOutput):
    """MLTableJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI. This will have a default value of
     "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "CustomModel", "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI. This will have a default value of
         "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(MLTableJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'MLTable'  # type: str
        self.description = description


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Possible values include:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Possible values
         include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Possible
         values include: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.machinelearningservices.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TritonModelJobInput(JobInput, AssetJobInput):
    """TritonModelJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(TritonModelJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'TritonModel'  # type: str
        self.description = description


class TritonModelJobOutput(JobOutputV2, AssetJobOutput):
    """TritonModelJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI. This will have a default value of
     "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "CustomModel", "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI. This will have a default value of
         "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(TritonModelJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'TritonModel'  # type: str
        self.description = description


class UriFileJobInput(JobInput, AssetJobInput):
    """UriFileJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(UriFileJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'UriFile'  # type: str
        self.description = description


class UriFileJobOutput(JobOutputV2, AssetJobOutput):
    """UriFileJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI. This will have a default value of
     "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "CustomModel", "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI. This will have a default value of
         "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(UriFileJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'UriFile'  # type: str
        self.description = description


class UriFolderJobInput(JobInput, AssetJobInput):
    """UriFolderJobInput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
     "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
    :ivar uri: Required. Input Asset URI.
    :vartype uri: str
    :ivar description: Description for the input.
    :vartype description: str
    :ivar job_input_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "Literal", "CustomModel", "MLFlowModel",
     "TritonModel".
    :vartype job_input_type: str or ~azure.mgmt.machinelearningservices.models.JobInputType
    """

    _validation = {
        'uri': {'required': True, 'pattern': r'[a-zA-Z0-9_]'},
        'job_input_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_input_type': {'key': 'jobInputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: str,
        mode: Optional[Union[str, "InputDeliveryMode"]] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Input Asset Delivery Mode. Possible values include: "ReadOnlyMount",
         "ReadWriteMount", "Download", "Direct", "EvalMount", "EvalDownload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.InputDeliveryMode
        :keyword uri: Required. Input Asset URI.
        :paramtype uri: str
        :keyword description: Description for the input.
        :paramtype description: str
        """
        super(UriFolderJobInput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_input_type = 'UriFolder'  # type: str
        self.description = description


class UriFolderJobOutput(JobOutputV2, AssetJobOutput):
    """UriFolderJobOutput.

    All required parameters must be populated in order to send to Azure.

    :ivar mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
    :vartype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
    :ivar uri: Output Asset URI. This will have a default value of
     "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
    :vartype uri: str
    :ivar description: Description for the output.
    :vartype description: str
    :ivar job_output_type: Required. Specifies the type of job.Constant filled by server. Possible
     values include: "UriFile", "UriFolder", "MLTable", "CustomModel", "MLFlowModel", "TritonModel".
    :vartype job_output_type: str or ~azure.mgmt.machinelearningservices.models.JobOutputType
    """

    _validation = {
        'job_output_type': {'required': True},
    }

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'job_output_type': {'key': 'jobOutputType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "OutputDeliveryMode"]] = None,
        uri: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword mode: Output Asset Delivery Mode. Possible values include: "ReadWriteMount", "Upload".
        :paramtype mode: str or ~azure.mgmt.machinelearningservices.models.OutputDeliveryMode
        :keyword uri: Output Asset URI. This will have a default value of
         "azureml/{jobId}/{outputFolder}/{outputFileName}" if omitted.
        :paramtype uri: str
        :keyword description: Description for the output.
        :paramtype description: str
        """
        super(UriFolderJobOutput, self).__init__(description=description, mode=mode, uri=uri, **kwargs)
        self.mode = mode
        self.uri = uri
        self.job_output_type = 'UriFolder'  # type: str
        self.description = description
