# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AzureMonitorWorkspaceIntegration(_serialization.Model):
    """Integrations for Azure Monitor Workspace.

    :ivar azure_monitor_workspace_resource_id: The resource Id of the connected Azure Monitor
     Workspace.
    :vartype azure_monitor_workspace_resource_id: str
    """

    _attribute_map = {
        "azure_monitor_workspace_resource_id": {"key": "azureMonitorWorkspaceResourceId", "type": "str"},
    }

    def __init__(self, *, azure_monitor_workspace_resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword azure_monitor_workspace_resource_id: The resource Id of the connected Azure Monitor
         Workspace.
        :paramtype azure_monitor_workspace_resource_id: str
        """
        super().__init__(**kwargs)
        self.azure_monitor_workspace_resource_id = azure_monitor_workspace_resource_id


class EnterpriseConfigurations(_serialization.Model):
    """Enterprise settings of a Grafana instance.

    :ivar marketplace_plan_id: The Plan Id of the Azure Marketplace subscription for the Enterprise
     plugins.
    :vartype marketplace_plan_id: str
    :ivar marketplace_auto_renew: The AutoRenew setting of the Enterprise subscription. Known
     values are: "Disabled" and "Enabled".
    :vartype marketplace_auto_renew: str or ~azure.mgmt.dashboard.models.MarketplaceAutoRenew
    """

    _attribute_map = {
        "marketplace_plan_id": {"key": "marketplacePlanId", "type": "str"},
        "marketplace_auto_renew": {"key": "marketplaceAutoRenew", "type": "str"},
    }

    def __init__(
        self,
        *,
        marketplace_plan_id: Optional[str] = None,
        marketplace_auto_renew: Optional[Union[str, "_models.MarketplaceAutoRenew"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword marketplace_plan_id: The Plan Id of the Azure Marketplace subscription for the
         Enterprise plugins.
        :paramtype marketplace_plan_id: str
        :keyword marketplace_auto_renew: The AutoRenew setting of the Enterprise subscription. Known
         values are: "Disabled" and "Enabled".
        :paramtype marketplace_auto_renew: str or ~azure.mgmt.dashboard.models.MarketplaceAutoRenew
        """
        super().__init__(**kwargs)
        self.marketplace_plan_id = marketplace_plan_id
        self.marketplace_auto_renew = marketplace_auto_renew


class EnterpriseDetails(_serialization.Model):
    """Enterprise details of a Grafana instance.

    :ivar saas_subscription_details: SaaS subscription details of a Grafana instance.
    :vartype saas_subscription_details: ~azure.mgmt.dashboard.models.SaasSubscriptionDetails
    :ivar marketplace_trial_quota: The allocation details of the per subscription free trial slot
     of the subscription.
    :vartype marketplace_trial_quota: ~azure.mgmt.dashboard.models.MarketplaceTrialQuota
    """

    _attribute_map = {
        "saas_subscription_details": {"key": "saasSubscriptionDetails", "type": "SaasSubscriptionDetails"},
        "marketplace_trial_quota": {"key": "marketplaceTrialQuota", "type": "MarketplaceTrialQuota"},
    }

    def __init__(
        self,
        *,
        saas_subscription_details: Optional["_models.SaasSubscriptionDetails"] = None,
        marketplace_trial_quota: Optional["_models.MarketplaceTrialQuota"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword saas_subscription_details: SaaS subscription details of a Grafana instance.
        :paramtype saas_subscription_details: ~azure.mgmt.dashboard.models.SaasSubscriptionDetails
        :keyword marketplace_trial_quota: The allocation details of the per subscription free trial
         slot of the subscription.
        :paramtype marketplace_trial_quota: ~azure.mgmt.dashboard.models.MarketplaceTrialQuota
        """
        super().__init__(**kwargs)
        self.saas_subscription_details = saas_subscription_details
        self.marketplace_trial_quota = marketplace_trial_quota


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dashboard.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dashboard.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.dashboard.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.dashboard.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class GrafanaAvailablePlugin(_serialization.Model):
    """Available plugins of grafana.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar plugin_id: Grafana plugin id.
    :vartype plugin_id: str
    :ivar name: Grafana plugin display name.
    :vartype name: str
    """

    _validation = {
        "plugin_id": {"readonly": True},
        "name": {"readonly": True},
    }

    _attribute_map = {
        "plugin_id": {"key": "pluginId", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.plugin_id = None
        self.name = None


class GrafanaAvailablePluginListResponse(_serialization.Model):
    """GrafanaAvailablePluginListResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.dashboard.models.GrafanaAvailablePlugin]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[GrafanaAvailablePlugin]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.GrafanaAvailablePlugin"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.dashboard.models.GrafanaAvailablePlugin]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GrafanaConfigurations(_serialization.Model):
    """Server configurations of a Grafana instance.

    :ivar smtp: Email server settings.
     https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp.
    :vartype smtp: ~azure.mgmt.dashboard.models.Smtp
    """

    _attribute_map = {
        "smtp": {"key": "smtp", "type": "Smtp"},
    }

    def __init__(self, *, smtp: Optional["_models.Smtp"] = None, **kwargs: Any) -> None:
        """
        :keyword smtp: Email server settings.
         https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp.
        :paramtype smtp: ~azure.mgmt.dashboard.models.Smtp
        """
        super().__init__(**kwargs)
        self.smtp = smtp


class GrafanaIntegrations(_serialization.Model):
    """GrafanaIntegrations is a bundled observability experience (e.g. pre-configured data source,
    tailored Grafana dashboards, alerting defaults) for common monitoring scenarios.

    :ivar azure_monitor_workspace_integrations:
    :vartype azure_monitor_workspace_integrations:
     list[~azure.mgmt.dashboard.models.AzureMonitorWorkspaceIntegration]
    """

    _attribute_map = {
        "azure_monitor_workspace_integrations": {
            "key": "azureMonitorWorkspaceIntegrations",
            "type": "[AzureMonitorWorkspaceIntegration]",
        },
    }

    def __init__(
        self,
        *,
        azure_monitor_workspace_integrations: Optional[List["_models.AzureMonitorWorkspaceIntegration"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_monitor_workspace_integrations:
        :paramtype azure_monitor_workspace_integrations:
         list[~azure.mgmt.dashboard.models.AzureMonitorWorkspaceIntegration]
        """
        super().__init__(**kwargs)
        self.azure_monitor_workspace_integrations = azure_monitor_workspace_integrations


class GrafanaPlugin(_serialization.Model):
    """Plugin of Grafana.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar plugin_id: Grafana plugin id.
    :vartype plugin_id: str
    """

    _validation = {
        "plugin_id": {"readonly": True},
    }

    _attribute_map = {
        "plugin_id": {"key": "pluginId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.plugin_id = None


class ManagedGrafana(_serialization.Model):
    """The grafana resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ARM id of the grafana resource.
    :vartype id: str
    :ivar name: Name of the grafana resource.
    :vartype name: str
    :ivar type: The type of the grafana resource.
    :vartype type: str
    :ivar sku: The Sku of the grafana resource.
    :vartype sku: ~azure.mgmt.dashboard.models.ResourceSku
    :ivar properties: Properties specific to the grafana resource.
    :vartype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaProperties
    :ivar identity: The managed identity of the grafana resource.
    :vartype identity: ~azure.mgmt.dashboard.models.ManagedServiceIdentity
    :ivar system_data: The system meta data relating to this grafana resource.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: The tags for grafana resource.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the grafana resource lives.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "sku": {"key": "sku", "type": "ResourceSku"},
        "properties": {"key": "properties", "type": "ManagedGrafanaProperties"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.ResourceSku"] = None,
        properties: Optional["_models.ManagedGrafanaProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku: The Sku of the grafana resource.
        :paramtype sku: ~azure.mgmt.dashboard.models.ResourceSku
        :keyword properties: Properties specific to the grafana resource.
        :paramtype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaProperties
        :keyword identity: The managed identity of the grafana resource.
        :paramtype identity: ~azure.mgmt.dashboard.models.ManagedServiceIdentity
        :keyword tags: The tags for grafana resource.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the grafana resource lives.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.sku = sku
        self.properties = properties
        self.identity = identity
        self.system_data = None
        self.tags = tags
        self.location = location


class ManagedGrafanaListResponse(_serialization.Model):
    """ManagedGrafanaListResponse.

    :ivar value:
    :vartype value: list[~azure.mgmt.dashboard.models.ManagedGrafana]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedGrafana]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ManagedGrafana"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.dashboard.models.ManagedGrafana]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedGrafanaProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties specific to the grafana resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar grafana_version: The Grafana software version.
    :vartype grafana_version: str
    :ivar endpoint: The endpoint of the Grafana instance.
    :vartype endpoint: str
    :ivar public_network_access: Indicate the state for enable or disable traffic over the public
     interface. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.dashboard.models.PublicNetworkAccess
    :ivar zone_redundancy: The zone redundancy setting of the Grafana instance. Known values are:
     "Disabled" and "Enabled".
    :vartype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
    :ivar api_key: The api key setting of the Grafana instance. Known values are: "Disabled" and
     "Enabled".
    :vartype api_key: str or ~azure.mgmt.dashboard.models.ApiKey
    :ivar deterministic_outbound_ip: Whether a Grafana instance uses deterministic outbound IPs.
     Known values are: "Disabled" and "Enabled".
    :vartype deterministic_outbound_ip: str or ~azure.mgmt.dashboard.models.DeterministicOutboundIP
    :ivar outbound_i_ps: List of outbound IPs if deterministicOutboundIP is enabled.
    :vartype outbound_i_ps: list[str]
    :ivar private_endpoint_connections: The private endpoint connections of the Grafana instance.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.dashboard.models.PrivateEndpointConnection]
    :ivar auto_generated_domain_name_label_scope: Scope for dns deterministic name hash
     calculation. "TenantReuse"
    :vartype auto_generated_domain_name_label_scope: str or
     ~azure.mgmt.dashboard.models.AutoGeneratedDomainNameLabelScope
    :ivar grafana_integrations: GrafanaIntegrations is a bundled observability experience (e.g.
     pre-configured data source, tailored Grafana dashboards, alerting defaults) for common
     monitoring scenarios.
    :vartype grafana_integrations: ~azure.mgmt.dashboard.models.GrafanaIntegrations
    :ivar enterprise_configurations: Enterprise settings of a Grafana instance.
    :vartype enterprise_configurations: ~azure.mgmt.dashboard.models.EnterpriseConfigurations
    :ivar grafana_configurations: Server configurations of a Grafana instance.
    :vartype grafana_configurations: ~azure.mgmt.dashboard.models.GrafanaConfigurations
    :ivar grafana_plugins: Installed plugin list of the Grafana instance. Key is plugin id, value
     is plugin definition.
    :vartype grafana_plugins: dict[str, ~azure.mgmt.dashboard.models.GrafanaPlugin]
    :ivar grafana_major_version: The major Grafana software version to target.
    :vartype grafana_major_version: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "grafana_version": {"readonly": True},
        "endpoint": {"readonly": True},
        "outbound_i_ps": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "grafana_version": {"key": "grafanaVersion", "type": "str"},
        "endpoint": {"key": "endpoint", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "zone_redundancy": {"key": "zoneRedundancy", "type": "str"},
        "api_key": {"key": "apiKey", "type": "str"},
        "deterministic_outbound_ip": {"key": "deterministicOutboundIP", "type": "str"},
        "outbound_i_ps": {"key": "outboundIPs", "type": "[str]"},
        "private_endpoint_connections": {"key": "privateEndpointConnections", "type": "[PrivateEndpointConnection]"},
        "auto_generated_domain_name_label_scope": {"key": "autoGeneratedDomainNameLabelScope", "type": "str"},
        "grafana_integrations": {"key": "grafanaIntegrations", "type": "GrafanaIntegrations"},
        "enterprise_configurations": {"key": "enterpriseConfigurations", "type": "EnterpriseConfigurations"},
        "grafana_configurations": {"key": "grafanaConfigurations", "type": "GrafanaConfigurations"},
        "grafana_plugins": {"key": "grafanaPlugins", "type": "{GrafanaPlugin}"},
        "grafana_major_version": {"key": "grafanaMajorVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        zone_redundancy: Union[str, "_models.ZoneRedundancy"] = "Disabled",
        api_key: Union[str, "_models.ApiKey"] = "Disabled",
        deterministic_outbound_ip: Union[str, "_models.DeterministicOutboundIP"] = "Disabled",
        auto_generated_domain_name_label_scope: Optional[
            Union[str, "_models.AutoGeneratedDomainNameLabelScope"]
        ] = None,
        grafana_integrations: Optional["_models.GrafanaIntegrations"] = None,
        enterprise_configurations: Optional["_models.EnterpriseConfigurations"] = None,
        grafana_configurations: Optional["_models.GrafanaConfigurations"] = None,
        grafana_plugins: Optional[Dict[str, "_models.GrafanaPlugin"]] = None,
        grafana_major_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_network_access: Indicate the state for enable or disable traffic over the
         public interface. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.dashboard.models.PublicNetworkAccess
        :keyword zone_redundancy: The zone redundancy setting of the Grafana instance. Known values
         are: "Disabled" and "Enabled".
        :paramtype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
        :keyword api_key: The api key setting of the Grafana instance. Known values are: "Disabled" and
         "Enabled".
        :paramtype api_key: str or ~azure.mgmt.dashboard.models.ApiKey
        :keyword deterministic_outbound_ip: Whether a Grafana instance uses deterministic outbound IPs.
         Known values are: "Disabled" and "Enabled".
        :paramtype deterministic_outbound_ip: str or
         ~azure.mgmt.dashboard.models.DeterministicOutboundIP
        :keyword auto_generated_domain_name_label_scope: Scope for dns deterministic name hash
         calculation. "TenantReuse"
        :paramtype auto_generated_domain_name_label_scope: str or
         ~azure.mgmt.dashboard.models.AutoGeneratedDomainNameLabelScope
        :keyword grafana_integrations: GrafanaIntegrations is a bundled observability experience (e.g.
         pre-configured data source, tailored Grafana dashboards, alerting defaults) for common
         monitoring scenarios.
        :paramtype grafana_integrations: ~azure.mgmt.dashboard.models.GrafanaIntegrations
        :keyword enterprise_configurations: Enterprise settings of a Grafana instance.
        :paramtype enterprise_configurations: ~azure.mgmt.dashboard.models.EnterpriseConfigurations
        :keyword grafana_configurations: Server configurations of a Grafana instance.
        :paramtype grafana_configurations: ~azure.mgmt.dashboard.models.GrafanaConfigurations
        :keyword grafana_plugins: Installed plugin list of the Grafana instance. Key is plugin id,
         value is plugin definition.
        :paramtype grafana_plugins: dict[str, ~azure.mgmt.dashboard.models.GrafanaPlugin]
        :keyword grafana_major_version: The major Grafana software version to target.
        :paramtype grafana_major_version: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.grafana_version = None
        self.endpoint = None
        self.public_network_access = public_network_access
        self.zone_redundancy = zone_redundancy
        self.api_key = api_key
        self.deterministic_outbound_ip = deterministic_outbound_ip
        self.outbound_i_ps = None
        self.private_endpoint_connections = None
        self.auto_generated_domain_name_label_scope = auto_generated_domain_name_label_scope
        self.grafana_integrations = grafana_integrations
        self.enterprise_configurations = enterprise_configurations
        self.grafana_configurations = grafana_configurations
        self.grafana_plugins = grafana_plugins
        self.grafana_major_version = grafana_major_version


class ManagedGrafanaPropertiesUpdateParameters(_serialization.Model):
    """The properties parameters for a PATCH request to a grafana resource.

    :ivar zone_redundancy: The zone redundancy setting of the Grafana instance. Known values are:
     "Disabled" and "Enabled".
    :vartype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
    :ivar api_key: The api key setting of the Grafana instance. Known values are: "Disabled" and
     "Enabled".
    :vartype api_key: str or ~azure.mgmt.dashboard.models.ApiKey
    :ivar deterministic_outbound_ip: Whether a Grafana instance uses deterministic outbound IPs.
     Known values are: "Disabled" and "Enabled".
    :vartype deterministic_outbound_ip: str or ~azure.mgmt.dashboard.models.DeterministicOutboundIP
    :ivar public_network_access: Indicate the state for enable or disable traffic over the public
     interface. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or ~azure.mgmt.dashboard.models.PublicNetworkAccess
    :ivar grafana_integrations: GrafanaIntegrations is a bundled observability experience (e.g.
     pre-configured data source, tailored Grafana dashboards, alerting defaults) for common
     monitoring scenarios.
    :vartype grafana_integrations: ~azure.mgmt.dashboard.models.GrafanaIntegrations
    :ivar enterprise_configurations: Enterprise settings of a Grafana instance.
    :vartype enterprise_configurations: ~azure.mgmt.dashboard.models.EnterpriseConfigurations
    :ivar grafana_configurations: Server configurations of a Grafana instance.
    :vartype grafana_configurations: ~azure.mgmt.dashboard.models.GrafanaConfigurations
    :ivar grafana_plugins: Update of Grafana plugin. Key is plugin id, value is plugin definition.
     If plugin definition is null, plugin with given plugin id will be removed. Otherwise, given
     plugin will be installed.
    :vartype grafana_plugins: dict[str, ~azure.mgmt.dashboard.models.GrafanaPlugin]
    :ivar grafana_major_version: The major Grafana software version to target.
    :vartype grafana_major_version: str
    """

    _attribute_map = {
        "zone_redundancy": {"key": "zoneRedundancy", "type": "str"},
        "api_key": {"key": "apiKey", "type": "str"},
        "deterministic_outbound_ip": {"key": "deterministicOutboundIP", "type": "str"},
        "public_network_access": {"key": "publicNetworkAccess", "type": "str"},
        "grafana_integrations": {"key": "grafanaIntegrations", "type": "GrafanaIntegrations"},
        "enterprise_configurations": {"key": "enterpriseConfigurations", "type": "EnterpriseConfigurations"},
        "grafana_configurations": {"key": "grafanaConfigurations", "type": "GrafanaConfigurations"},
        "grafana_plugins": {"key": "grafanaPlugins", "type": "{GrafanaPlugin}"},
        "grafana_major_version": {"key": "grafanaMajorVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        zone_redundancy: Union[str, "_models.ZoneRedundancy"] = "Disabled",
        api_key: Union[str, "_models.ApiKey"] = "Disabled",
        deterministic_outbound_ip: Union[str, "_models.DeterministicOutboundIP"] = "Disabled",
        public_network_access: Union[str, "_models.PublicNetworkAccess"] = "Enabled",
        grafana_integrations: Optional["_models.GrafanaIntegrations"] = None,
        enterprise_configurations: Optional["_models.EnterpriseConfigurations"] = None,
        grafana_configurations: Optional["_models.GrafanaConfigurations"] = None,
        grafana_plugins: Optional[Dict[str, "_models.GrafanaPlugin"]] = None,
        grafana_major_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword zone_redundancy: The zone redundancy setting of the Grafana instance. Known values
         are: "Disabled" and "Enabled".
        :paramtype zone_redundancy: str or ~azure.mgmt.dashboard.models.ZoneRedundancy
        :keyword api_key: The api key setting of the Grafana instance. Known values are: "Disabled" and
         "Enabled".
        :paramtype api_key: str or ~azure.mgmt.dashboard.models.ApiKey
        :keyword deterministic_outbound_ip: Whether a Grafana instance uses deterministic outbound IPs.
         Known values are: "Disabled" and "Enabled".
        :paramtype deterministic_outbound_ip: str or
         ~azure.mgmt.dashboard.models.DeterministicOutboundIP
        :keyword public_network_access: Indicate the state for enable or disable traffic over the
         public interface. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or ~azure.mgmt.dashboard.models.PublicNetworkAccess
        :keyword grafana_integrations: GrafanaIntegrations is a bundled observability experience (e.g.
         pre-configured data source, tailored Grafana dashboards, alerting defaults) for common
         monitoring scenarios.
        :paramtype grafana_integrations: ~azure.mgmt.dashboard.models.GrafanaIntegrations
        :keyword enterprise_configurations: Enterprise settings of a Grafana instance.
        :paramtype enterprise_configurations: ~azure.mgmt.dashboard.models.EnterpriseConfigurations
        :keyword grafana_configurations: Server configurations of a Grafana instance.
        :paramtype grafana_configurations: ~azure.mgmt.dashboard.models.GrafanaConfigurations
        :keyword grafana_plugins: Update of Grafana plugin. Key is plugin id, value is plugin
         definition. If plugin definition is null, plugin with given plugin id will be removed.
         Otherwise, given plugin will be installed.
        :paramtype grafana_plugins: dict[str, ~azure.mgmt.dashboard.models.GrafanaPlugin]
        :keyword grafana_major_version: The major Grafana software version to target.
        :paramtype grafana_major_version: str
        """
        super().__init__(**kwargs)
        self.zone_redundancy = zone_redundancy
        self.api_key = api_key
        self.deterministic_outbound_ip = deterministic_outbound_ip
        self.public_network_access = public_network_access
        self.grafana_integrations = grafana_integrations
        self.enterprise_configurations = enterprise_configurations
        self.grafana_configurations = grafana_configurations
        self.grafana_plugins = grafana_plugins
        self.grafana_major_version = grafana_major_version


class ManagedGrafanaUpdateParameters(_serialization.Model):
    """The parameters for a PATCH request to a grafana resource.

    :ivar sku:
    :vartype sku: ~azure.mgmt.dashboard.models.ResourceSku
    :ivar identity: The managed identity of the grafana resource.
    :vartype identity: ~azure.mgmt.dashboard.models.ManagedServiceIdentity
    :ivar tags: The new tags of the grafana resource.
    :vartype tags: dict[str, str]
    :ivar properties: Properties specific to the managed grafana resource.
    :vartype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaPropertiesUpdateParameters
    """

    _attribute_map = {
        "sku": {"key": "sku", "type": "ResourceSku"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "ManagedGrafanaPropertiesUpdateParameters"},
    }

    def __init__(
        self,
        *,
        sku: Optional["_models.ResourceSku"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ManagedGrafanaPropertiesUpdateParameters"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword sku:
        :paramtype sku: ~azure.mgmt.dashboard.models.ResourceSku
        :keyword identity: The managed identity of the grafana resource.
        :paramtype identity: ~azure.mgmt.dashboard.models.ManagedServiceIdentity
        :keyword tags: The new tags of the grafana resource.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties specific to the managed grafana resource.
        :paramtype properties: ~azure.mgmt.dashboard.models.ManagedGrafanaPropertiesUpdateParameters
        """
        super().__init__(**kwargs)
        self.sku = sku
        self.identity = identity
        self.tags = tags
        self.properties = properties


class ManagedPrivateEndpointConnectionState(_serialization.Model):
    """The state of managed private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The approval/rejection status of managed private endpoint connection. Known
     values are: "Pending", "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.dashboard.models.ManagedPrivateEndpointConnectionStatus
    :ivar description: Gets or sets the reason for approval/rejection of the connection.
    :vartype description: str
    """

    _validation = {
        "status": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.description = None


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class ManagedPrivateEndpointModel(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The managed private endpoint resource type.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar private_link_resource_id: The ARM resource ID of the resource for which the managed
     private endpoint is pointing to.
    :vartype private_link_resource_id: str
    :ivar private_link_resource_region: The region of the resource to which the managed private
     endpoint is pointing to.
    :vartype private_link_resource_region: str
    :ivar group_ids: The group Ids of the managed private endpoint.
    :vartype group_ids: list[str]
    :ivar request_message: User input request message of the managed private endpoint.
    :vartype request_message: str
    :ivar connection_state: The state of managed private endpoint connection.
    :vartype connection_state: ~azure.mgmt.dashboard.models.ManagedPrivateEndpointConnectionState
    :ivar private_link_service_url: The URL of the data store behind the private link service. It
     would be the URL in the Grafana data source configuration page without the protocol and port.
    :vartype private_link_service_url: str
    :ivar private_link_service_private_ip: The private IP of private endpoint after approval. This
     property is empty before connection is approved.
    :vartype private_link_service_private_ip: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "connection_state": {"readonly": True},
        "private_link_service_private_ip": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_link_resource_id": {"key": "properties.privateLinkResourceId", "type": "str"},
        "private_link_resource_region": {"key": "properties.privateLinkResourceRegion", "type": "str"},
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "request_message": {"key": "properties.requestMessage", "type": "str"},
        "connection_state": {"key": "properties.connectionState", "type": "ManagedPrivateEndpointConnectionState"},
        "private_link_service_url": {"key": "properties.privateLinkServiceUrl", "type": "str"},
        "private_link_service_private_ip": {"key": "properties.privateLinkServicePrivateIP", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        private_link_resource_id: Optional[str] = None,
        private_link_resource_region: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        request_message: Optional[str] = None,
        private_link_service_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword private_link_resource_id: The ARM resource ID of the resource for which the managed
         private endpoint is pointing to.
        :paramtype private_link_resource_id: str
        :keyword private_link_resource_region: The region of the resource to which the managed private
         endpoint is pointing to.
        :paramtype private_link_resource_region: str
        :keyword group_ids: The group Ids of the managed private endpoint.
        :paramtype group_ids: list[str]
        :keyword request_message: User input request message of the managed private endpoint.
        :paramtype request_message: str
        :keyword private_link_service_url: The URL of the data store behind the private link service.
         It would be the URL in the Grafana data source configuration page without the protocol and
         port.
        :paramtype private_link_service_url: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.private_link_resource_id = private_link_resource_id
        self.private_link_resource_region = private_link_resource_region
        self.group_ids = group_ids
        self.request_message = request_message
        self.connection_state = None
        self.private_link_service_url = private_link_service_url
        self.private_link_service_private_ip = None


class ManagedPrivateEndpointModelListResponse(_serialization.Model):
    """The list of managed private endpoints of a grafana resource.

    :ivar value:
    :vartype value: list[~azure.mgmt.dashboard.models.ManagedPrivateEndpointModel]
    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedPrivateEndpointModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ManagedPrivateEndpointModel"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.dashboard.models.ManagedPrivateEndpointModel]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedPrivateEndpointUpdateParameters(_serialization.Model):
    """The parameters for a PATCH request to a managed private endpoint.

    :ivar tags: The new tags of the managed private endpoint.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: The new tags of the managed private endpoint.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (system assigned and/or user assigned identities).

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: Type of managed service identity (where both SystemAssigned and UserAssigned types
     are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.dashboard.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str, ~azure.mgmt.dashboard.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (where both SystemAssigned and UserAssigned
         types are allowed). Required. Known values are: "None", "SystemAssigned", "UserAssigned", and
         "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.dashboard.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.dashboard.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MarketplaceTrialQuota(_serialization.Model):
    """The allocation details of the per subscription free trial slot of the subscription.

    :ivar available_promotion: Available enterprise promotion for the subscription. Known values
     are: "None" and "FreeTrial".
    :vartype available_promotion: str or ~azure.mgmt.dashboard.models.AvailablePromotion
    :ivar grafana_resource_id: Resource Id of the Grafana resource which is doing the trial.
    :vartype grafana_resource_id: str
    :ivar trial_start_at: The date and time in UTC of when the trial starts.
    :vartype trial_start_at: ~datetime.datetime
    :ivar trial_end_at: The date and time in UTC of when the trial ends.
    :vartype trial_end_at: ~datetime.datetime
    """

    _attribute_map = {
        "available_promotion": {"key": "availablePromotion", "type": "str"},
        "grafana_resource_id": {"key": "grafanaResourceId", "type": "str"},
        "trial_start_at": {"key": "trialStartAt", "type": "iso-8601"},
        "trial_end_at": {"key": "trialEndAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        available_promotion: Union[str, "_models.AvailablePromotion"] = "None",
        grafana_resource_id: Optional[str] = None,
        trial_start_at: Optional[datetime.datetime] = None,
        trial_end_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword available_promotion: Available enterprise promotion for the subscription. Known values
         are: "None" and "FreeTrial".
        :paramtype available_promotion: str or ~azure.mgmt.dashboard.models.AvailablePromotion
        :keyword grafana_resource_id: Resource Id of the Grafana resource which is doing the trial.
        :paramtype grafana_resource_id: str
        :keyword trial_start_at: The date and time in UTC of when the trial starts.
        :paramtype trial_start_at: ~datetime.datetime
        :keyword trial_end_at: The date and time in UTC of when the trial ends.
        :paramtype trial_end_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.available_promotion = available_promotion
        self.grafana_resource_id = grafana_resource_id
        self.trial_start_at = trial_start_at
        self.trial_end_at = trial_end_at


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.dashboard.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.dashboard.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.dashboard.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.dashboard.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.dashboard.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar private_endpoint: The resource of private end point.
    :vartype private_endpoint: ~azure.mgmt.dashboard.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.dashboard.models.PrivateLinkServiceConnectionState
    :ivar group_ids: The private endpoint connection group ids.
    :vartype group_ids: list[str]
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Known values are: "Succeeded", "Creating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.dashboard.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
        "group_ids": {"key": "properties.groupIds", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        group_ids: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private end point.
        :paramtype private_endpoint: ~azure.mgmt.dashboard.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.dashboard.models.PrivateLinkServiceConnectionState
        :keyword group_ids: The private endpoint connection group ids.
        :paramtype group_ids: list[str]
        """
        super().__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.group_ids = group_ids
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(_serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private endpoint connections.
    :vartype value: list[~azure.mgmt.dashboard.models.PrivateEndpointConnection]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateEndpointConnection"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private endpoint connections.
        :paramtype value: list[~azure.mgmt.dashboard.models.PrivateEndpointConnection]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dashboard.models.SystemData
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dashboard.models.ProvisioningState
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The private link resource Private link DNS zone name.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, *, required_zone_names: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword required_zone_names: The private link resource Private link DNS zone name.
        :paramtype required_zone_names: list[str]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Array of private link resources.
    :vartype value: list[~azure.mgmt.dashboard.models.PrivateLinkResource]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PrivateLinkResource"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: Array of private link resources.
        :paramtype value: list[~azure.mgmt.dashboard.models.PrivateLinkResource]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PrivateLinkServiceConnectionState(_serialization.Model):
    """A collection of information about the state of the connection between service consumer and
    provider.

    :ivar status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Known values are: "Pending", "Approved", and "Rejected".
    :vartype status: str or ~azure.mgmt.dashboard.models.PrivateEndpointServiceConnectionStatus
    :ivar description: The reason for approval/rejection of the connection.
    :vartype description: str
    :ivar actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :vartype actions_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Indicates whether the connection has been Approved/Rejected/Removed by the
         owner of the service. Known values are: "Pending", "Approved", and "Rejected".
        :paramtype status: str or ~azure.mgmt.dashboard.models.PrivateEndpointServiceConnectionStatus
        :keyword description: The reason for approval/rejection of the connection.
        :paramtype description: str
        :keyword actions_required: A message indicating if changes on the service provider require any
         updates on the consumer.
        :paramtype actions_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ResourceSku(_serialization.Model):
    """ResourceSku.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class SaasSubscriptionDetails(_serialization.Model):
    """SaaS subscription details of a Grafana instance.

    :ivar plan_id: The plan Id of the SaaS subscription.
    :vartype plan_id: str
    :ivar offer_id: The offer Id of the SaaS subscription.
    :vartype offer_id: str
    :ivar publisher_id: The publisher Id of the SaaS subscription.
    :vartype publisher_id: str
    :ivar term: The billing term of the SaaS Subscription.
    :vartype term: ~azure.mgmt.dashboard.models.SubscriptionTerm
    """

    _attribute_map = {
        "plan_id": {"key": "planId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
        "publisher_id": {"key": "publisherId", "type": "str"},
        "term": {"key": "term", "type": "SubscriptionTerm"},
    }

    def __init__(
        self,
        *,
        plan_id: Optional[str] = None,
        offer_id: Optional[str] = None,
        publisher_id: Optional[str] = None,
        term: Optional["_models.SubscriptionTerm"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword plan_id: The plan Id of the SaaS subscription.
        :paramtype plan_id: str
        :keyword offer_id: The offer Id of the SaaS subscription.
        :paramtype offer_id: str
        :keyword publisher_id: The publisher Id of the SaaS subscription.
        :paramtype publisher_id: str
        :keyword term: The billing term of the SaaS Subscription.
        :paramtype term: ~azure.mgmt.dashboard.models.SubscriptionTerm
        """
        super().__init__(**kwargs)
        self.plan_id = plan_id
        self.offer_id = offer_id
        self.publisher_id = publisher_id
        self.term = term


class Smtp(_serialization.Model):
    """Email server settings.
    https://grafana.com/docs/grafana/v9.0/setup-grafana/configure-grafana/#smtp.

    :ivar enabled: Enable this to allow Grafana to send email. Default is false.
    :vartype enabled: bool
    :ivar host: SMTP server hostname with port, e.g. test.email.net:587.
    :vartype host: str
    :ivar user: User of SMTP auth.
    :vartype user: str
    :ivar password: Password of SMTP auth. If the password contains # or ;, then you have to wrap
     it with triple quotes.
    :vartype password: str
    :ivar from_address: Address used when sending out emails
     https://pkg.go.dev/net/mail#Address.
    :vartype from_address: str
    :ivar from_name: Name to be used when sending out emails. Default is "Azure Managed Grafana
     Notification"
     https://pkg.go.dev/net/mail#Address.
    :vartype from_name: str
    :ivar start_tls_policy: The StartTLSPolicy setting of the SMTP configuration
     https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy. Known values are:
     "OpportunisticStartTLS", "MandatoryStartTLS", and "NoStartTLS".
    :vartype start_tls_policy: str or ~azure.mgmt.dashboard.models.StartTLSPolicy
    :ivar skip_verify: Verify SSL for SMTP server. Default is false
     https://pkg.go.dev/crypto/tls#Config.
    :vartype skip_verify: bool
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "host": {"key": "host", "type": "str"},
        "user": {"key": "user", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "from_address": {"key": "fromAddress", "type": "str"},
        "from_name": {"key": "fromName", "type": "str"},
        "start_tls_policy": {"key": "startTLSPolicy", "type": "str"},
        "skip_verify": {"key": "skipVerify", "type": "bool"},
    }

    def __init__(
        self,
        *,
        enabled: bool = False,
        host: Optional[str] = None,
        user: Optional[str] = None,
        password: Optional[str] = None,
        from_address: Optional[str] = None,
        from_name: Optional[str] = None,
        start_tls_policy: Optional[Union[str, "_models.StartTLSPolicy"]] = None,
        skip_verify: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Enable this to allow Grafana to send email. Default is false.
        :paramtype enabled: bool
        :keyword host: SMTP server hostname with port, e.g. test.email.net:587.
        :paramtype host: str
        :keyword user: User of SMTP auth.
        :paramtype user: str
        :keyword password: Password of SMTP auth. If the password contains # or ;, then you have to
         wrap it with triple quotes.
        :paramtype password: str
        :keyword from_address: Address used when sending out emails
         https://pkg.go.dev/net/mail#Address.
        :paramtype from_address: str
        :keyword from_name: Name to be used when sending out emails. Default is "Azure Managed Grafana
         Notification"
         https://pkg.go.dev/net/mail#Address.
        :paramtype from_name: str
        :keyword start_tls_policy: The StartTLSPolicy setting of the SMTP configuration
         https://pkg.go.dev/github.com/go-mail/mail#StartTLSPolicy. Known values are:
         "OpportunisticStartTLS", "MandatoryStartTLS", and "NoStartTLS".
        :paramtype start_tls_policy: str or ~azure.mgmt.dashboard.models.StartTLSPolicy
        :keyword skip_verify: Verify SSL for SMTP server. Default is false
         https://pkg.go.dev/crypto/tls#Config.
        :paramtype skip_verify: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.host = host
        self.user = user
        self.password = password
        self.from_address = from_address
        self.from_name = from_name
        self.start_tls_policy = start_tls_policy
        self.skip_verify = skip_verify


class SubscriptionTerm(_serialization.Model):
    """The current billing term of the SaaS Subscription.

    :ivar term_unit: The unit of the billing term.
    :vartype term_unit: str
    :ivar start_date: The date and time in UTC of when the billing term starts.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: The date and time in UTC of when the billing term ends.
    :vartype end_date: ~datetime.datetime
    """

    _attribute_map = {
        "term_unit": {"key": "termUnit", "type": "str"},
        "start_date": {"key": "startDate", "type": "iso-8601"},
        "end_date": {"key": "endDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        term_unit: Optional[str] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword term_unit: The unit of the billing term.
        :paramtype term_unit: str
        :keyword start_date: The date and time in UTC of when the billing term starts.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: The date and time in UTC of when the billing term ends.
        :paramtype end_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.term_unit = term_unit
        self.start_date = start_date
        self.end_date = end_date


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.dashboard.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
