# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.mgmt.core.exceptions import ARMErrorFormat

from .. import models as _models
from .._vendor import _convert_request

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Optional, TypeVar
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_start_migration_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    migration = kwargs.pop('migration', None)  # type: Optional[str]
    timeout = kwargs.pop('timeout', "00:01:00")  # type: Optional[str]
    collection_id = kwargs.pop('collection_id', None)  # type: Optional[str]
    workspace_id = kwargs.pop('workspace_id', None)  # type: Optional[str]

    # Construct URL
    _url = kwargs.pop("template_url", "/modelregistry/v1.0/meta/migration")

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if migration is not None:
        _query_parameters['migration'] = _SERIALIZER.query("migration", migration, 'str')
    if timeout is not None:
        _query_parameters['timeout'] = _SERIALIZER.query("timeout", timeout, 'str')
    if collection_id is not None:
        _query_parameters['collectionId'] = _SERIALIZER.query("collection_id", collection_id, 'str')
    if workspace_id is not None:
        _query_parameters['workspaceId'] = _SERIALIZER.query("workspace_id", workspace_id, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_query_parameters,
        **kwargs
    )

# fmt: on
class MigrationOperations(object):
    """MigrationOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.machinelearningservices.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def start_migration(  # pylint: disable=inconsistent-return-statements
        self,
        migration=None,  # type: Optional[str]
        timeout="00:01:00",  # type: Optional[str]
        collection_id=None,  # type: Optional[str]
        workspace_id=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """start_migration.

        :param migration:
        :type migration: str
        :param timeout:
        :type timeout: str
        :param collection_id:
        :type collection_id: str
        :param workspace_id:
        :type workspace_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_start_migration_request(
            migration=migration,
            timeout=timeout,
            collection_id=collection_id,
            workspace_id=workspace_id,
            template_url=self.start_migration.metadata['url'],
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    start_migration.metadata = {'url': "/modelregistry/v1.0/meta/migration"}  # type: ignore

