# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.hybridnetwork import HybridNetworkManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hybridnetwork
# USAGE
    python vendor_sku_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HybridNetworkManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.vendor_skus.begin_create_or_update(
        vendor_name="TestVendor",
        sku_name="TestSku",
        parameters={
            "properties": {
                "deploymentMode": "PrivateEdgeZone",
                "managedApplicationTemplate": {},
                "networkFunctionTemplate": {
                    "networkFunctionRoleConfigurations": [
                        {
                            "customProfile": {"metadataConfigurationPath": "/var/logs/network.cfg"},
                            "networkInterfaces": [
                                {
                                    "ipConfigurations": [
                                        {
                                            "dnsServers": None,
                                            "gateway": "",
                                            "ipAddress": "",
                                            "ipAllocationMethod": "Dynamic",
                                            "ipVersion": "IPv4",
                                            "subnet": "",
                                        }
                                    ],
                                    "macAddress": "",
                                    "networkInterfaceName": "nic1",
                                    "vmSwitchType": "Wan",
                                },
                                {
                                    "ipConfigurations": [
                                        {
                                            "dnsServers": None,
                                            "gateway": "",
                                            "ipAddress": "",
                                            "ipAllocationMethod": "Dynamic",
                                            "ipVersion": "IPv4",
                                            "subnet": "",
                                        }
                                    ],
                                    "macAddress": "",
                                    "networkInterfaceName": "nic2",
                                    "vmSwitchType": "Management",
                                },
                            ],
                            "osProfile": {
                                "adminUsername": "dummyuser",
                                "customData": "base-64 encoded string of custom data",
                                "linuxConfiguration": {
                                    "ssh": {
                                        "publicKeys": [
                                            {
                                                "keyData": "ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAgEAwrr66r8n6B8Y0zMF3dOpXEapIQD9DiYQ6D6/zwor9o39jSkHNiMMER/GETBbzP83LOcekm02aRjo55ArO7gPPVvCXbrirJu9pkm4AC4BBre5xSLS= user@constoso-DSH",
                                                "path": "home/user/.ssh/authorized_keys",
                                            }
                                        ]
                                    }
                                },
                            },
                            "roleName": "test",
                            "roleType": "VirtualMachine",
                            "storageProfile": {
                                "dataDisks": [{"createOption": "Empty", "diskSizeGB": 10, "name": "DataDisk1"}],
                                "imageReference": {
                                    "offer": "UbuntuServer",
                                    "publisher": "Canonical",
                                    "sku": "18.04-LTS",
                                    "version": "18.04.201804262",
                                },
                                "osDisk": {
                                    "diskSizeGB": 30,
                                    "name": "vhdName",
                                    "osType": "Linux",
                                    "vhd": {
                                        "uri": "https://contoso.net/link/vnd.vhd?sp=rl&st=2020-10-08T20:38:19Z&se=2020-12-09T19:38:00Z&sv=2019-12-12&sr=b&sig=7BM2f4yOw%3D"
                                    },
                                },
                            },
                            "virtualMachineSize": "Standard_D3_v2",
                        }
                    ]
                },
                "networkFunctionType": "VirtualNetworkFunction",
                "preview": True,
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/hybridnetwork/resource-manager/Microsoft.HybridNetwork/preview/2022-01-01-preview/examples/VendorSkuCreate.json
if __name__ == "__main__":
    main()
