# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessProtocol(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AccessProtocol."""

    SMB = "SMB"
    """Server Message Block protocol(SMB)."""
    NFS = "NFS"
    """Network File System protocol(NFS)."""


class AddressType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of address."""

    NONE = "None"
    """Address type not known."""
    RESIDENTIAL = "Residential"
    """Residential Address."""
    COMMERCIAL = "Commercial"
    """Commercial Address."""


class AddressValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The address validation status."""

    VALID = "Valid"
    """Address provided is valid."""
    INVALID = "Invalid"
    """Address provided is invalid or not supported."""
    AMBIGUOUS = "Ambiguous"
    """Address provided is ambiguous, please choose one of the alternate addresses returned."""


class ClassDiscriminator(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the type of job details."""

    DATA_BOX = "DataBox"
    """DataBox orders."""
    DATA_BOX_DISK = "DataBoxDisk"
    """DataBoxDisk orders."""
    DATA_BOX_HEAVY = "DataBoxHeavy"
    """DataBoxHeavy orders."""


class CopyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The Status of the copy."""

    NOT_STARTED = "NotStarted"
    """Data copy hasn't started yet."""
    IN_PROGRESS = "InProgress"
    """Data copy is in progress."""
    COMPLETED = "Completed"
    """Data copy completed."""
    COMPLETED_WITH_ERRORS = "CompletedWithErrors"
    """Data copy completed with errors."""
    FAILED = "Failed"
    """Data copy failed. No data was copied."""
    NOT_RETURNED = "NotReturned"
    """No copy triggered as device was not returned."""


class DataDestinationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Data Destination Type."""

    UNKNOWN_TYPE = "UnknownType"
    """Unknown type."""
    STORAGE_ACCOUNT = "StorageAccount"
    """Storage Accounts ."""
    MANAGED_DISK = "ManagedDisk"
    """Azure Managed disk storage."""


class NotificationStageName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the stage."""

    DEVICE_PREPARED = "DevicePrepared"
    """Notification at device prepared stage."""
    DISPATCHED = "Dispatched"
    """Notification at device dispatched stage."""
    DELIVERED = "Delivered"
    """Notification at device delivered stage."""
    PICKED_UP = "PickedUp"
    """Notification at device picked up from user stage."""
    AT_AZURE_DC = "AtAzureDC"
    """Notification at device received at azure datacenter stage."""
    DATA_COPY = "DataCopy"
    """Notification at data copy started stage."""


class ShareDestinationFormatType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the share."""

    UNKNOWN_TYPE = "UnknownType"
    """Unknown format."""
    HCS = "HCS"
    """StorSimple data format."""
    BLOCK_BLOB = "BlockBlob"
    """Azure storage block blob format."""
    PAGE_BLOB = "PageBlob"
    """Azure storage page blob format."""
    AZURE_FILE = "AzureFile"
    """Azure storage file format."""
    MANAGED_DISK = "ManagedDisk"
    """Azure Compute Disk."""


class SkuDisabledReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Reason why the Sku is disabled."""

    NONE = "None"
    """SKU is not disabled."""
    COUNTRY = "Country"
    """SKU is not available in the requested country."""
    REGION = "Region"
    """SKU is not available to push data to the requested Azure region."""
    FEATURE = "Feature"
    """Required features are not enabled for the SKU."""
    OFFER_TYPE = "OfferType"
    """Subscription does not have required offer types for the SKU."""
    NO_SUBSCRIPTION_INFO = "NoSubscriptionInfo"
    """Subscription has not registered to Microsoft.DataBox and Service does not have the subscription
    #: notification."""


class SkuName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SkuName."""

    DATA_BOX = "DataBox"
    """DataBox."""
    DATA_BOX_DISK = "DataBoxDisk"
    """DataBoxDisk."""
    DATA_BOX_HEAVY = "DataBoxHeavy"
    """DataBoxHeavy."""


class StageName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the stage which is in progress."""

    DEVICE_ORDERED = "DeviceOrdered"
    """An order has been created."""
    DEVICE_PREPARED = "DevicePrepared"
    """A device has been prepared for the order."""
    DISPATCHED = "Dispatched"
    """Device has been dispatched to the user of the order."""
    DELIVERED = "Delivered"
    """Device has been delivered to the user of the order."""
    PICKED_UP = "PickedUp"
    """Device has been picked up from user and in transit to azure datacenter."""
    AT_AZURE_DC = "AtAzureDC"
    """Device has been received at azure datacenter from the user."""
    DATA_COPY = "DataCopy"
    """Data copy from the device at azure datacenter."""
    COMPLETED = "Completed"
    """Order has completed."""
    COMPLETED_WITH_ERRORS = "CompletedWithErrors"
    """Order has completed with errors."""
    CANCELLED = "Cancelled"
    """Order has been cancelled."""
    FAILED_ISSUE_REPORTED_AT_CUSTOMER = "Failed_IssueReportedAtCustomer"
    """Order has failed due to issue reported by user."""
    FAILED_ISSUE_DETECTED_AT_AZURE_DC = "Failed_IssueDetectedAtAzureDC"
    """Order has failed due to issue detected at azure datacenter."""
    ABORTED = "Aborted"
    """Order has been aborted."""


class StageStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Status of the job stage."""

    NONE = "None"
    """No status available yet."""
    IN_PROGRESS = "InProgress"
    """Stage is in progress."""
    SUCCEEDED = "Succeeded"
    """Stage has succeeded."""
    FAILED = "Failed"
    """Stage has failed."""
    CANCELLED = "Cancelled"
    """Stage has been cancelled."""
    CANCELLING = "Cancelling"
    """Stage is cancelling."""
    SUCCEEDED_WITH_ERRORS = "SucceededWithErrors"
    """Stage has succeeded with errors."""
