# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from azure.core import AsyncPipelineClient
from msrest import Serializer, Deserializer

from ._configuration_async import AzureAppConfigurationConfiguration
from .operations_async import AzureAppConfigurationOperationsMixin
from .. import models


class AzureAppConfiguration(AzureAppConfigurationOperationsMixin):
    """AzureAppConfiguration


    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param endpoint: The endpoint of the App Configuration instance to send
     requests to.
    :type endpoint: str
    :param sync_token: Used to guarantee real-time consistency between
     requests.
    :type sync_token: str
    """

    def __init__(
            self, credentials, endpoint, sync_token=None, **kwargs):

        base_url = '{endpoint}'
        self._config = AzureAppConfigurationConfiguration(credentials, endpoint, sync_token, **kwargs)
        self._client = AsyncPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1.0'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    async def __aenter__(self):
        await self._client.__aenter__()
        return self
    async def __aexit__(self, *exc_details):
        await self._client.__aexit__(*exc_details)
