/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.MessageHeader;
import org.netbeans.modules.xml.wsdl.model.Binding;

/**
 *
 * @author  Martin Grebac
 */
public class AddHeaderPanel extends javax.swing.JPanel {
    
    Binding binding = null;
    
    /**
     * Creates new form AddHeaderPanel
     */
    public AddHeaderPanel(Binding b) {
        super();
        initComponents();

        this.binding = b;

//        boolean rm = true;
//        if (binding != null) {
//            rm = RMModelHelper.isRMEnabled(binding);
//        }
        
        headerCombo.addItem(MessageHeader.ADDRESSING_TO);
        headerCombo.addItem(MessageHeader.ADDRESSING_FROM);
        headerCombo.addItem(MessageHeader.ADDRESSING_FAULTTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_REPLYTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_MESSAGEID);
        headerCombo.addItem(MessageHeader.ADDRESSING_RELATESTO);
        headerCombo.addItem(MessageHeader.ADDRESSING_ACTION);

//        if (rm) {
            headerCombo.addItem(MessageHeader.RM_ACKREQUESTED);
            headerCombo.addItem(MessageHeader.RM_SEQUENCEACK);
            headerCombo.addItem(MessageHeader.RM_SEQUENCE);
//        }
    }
    
    public boolean isAllHeaders() {
        return allHeadersChBox.isSelected();
    }

    public String getHeader() {
        return (String)headerCombo.getSelectedItem();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        headerLabel = new javax.swing.JLabel();
        headerCombo = new javax.swing.JComboBox();
        allHeadersChBox = new javax.swing.JCheckBox();

        headerLabel.setText(org.openide.util.NbBundle.getMessage(AddHeaderPanel.class, "LBL_AddHeader_HeaderLabel")); // NOI18N

        allHeadersChBox.setText(org.openide.util.NbBundle.getMessage(AddHeaderPanel.class, "LBL_AllHeaders")); // NOI18N
        allHeadersChBox.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        allHeadersChBox.setMargin(new java.awt.Insets(0, 0, 0, 0));
        allHeadersChBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                allHeadersChBoxActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(headerLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(headerCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(allHeadersChBox)
                .addContainerGap(112, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(headerLabel)
                    .addComponent(headerCombo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(allHeadersChBox))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void allHeadersChBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allHeadersChBoxActionPerformed
        headerCombo.setEnabled(!allHeadersChBox.isSelected());
    }//GEN-LAST:event_allHeadersChBoxActionPerformed
            
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox allHeadersChBox;
    private javax.swing.JComboBox headerCombo;
    private javax.swing.JLabel headerLabel;
    // End of variables declaration//GEN-END:variables
    
}
