/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFCatalog;
import gnu.jpdf.PDFFont;
import gnu.jpdf.PDFImage;
import gnu.jpdf.PDFInfo;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFOutline;
import gnu.jpdf.PDFOutput;
import gnu.jpdf.PDFPage;
import gnu.jpdf.PDFPageList;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;

public class PDFDocument
implements Serializable {
    protected int objser = 1;
    protected final Vector<PDFObject> objects = new Vector();
    private final PDFCatalog catalog;
    private PDFInfo info;
    private final PDFPageList pdfPageList;
    private PDFOutline outline;
    protected PDFObject defaultOutlineBorder;
    public static final int USENONE = 0;
    public static final int USEOUTLINES = 1;
    public static final int USETHUMBS = 2;
    public static final int FULLSCREEN = 3;
    public static final String[] PDF_PAGE_MODES = new String[]{"/UseNone", "/UseOutlines", "/UseThumbs", "/FullScreen"};
    private int fontid = 0;
    private int imageid = 0;
    private final Vector<PDFFont> fonts = new Vector();

    public PDFDocument() {
        this(0);
    }

    public PDFDocument(int n) {
        this.pdfPageList = new PDFPageList();
        this.add(this.pdfPageList);
        this.catalog = new PDFCatalog(this.pdfPageList, n);
        this.add(this.catalog);
        this.info = new PDFInfo();
        this.add(this.info);
        this.add(this.getOutline());
    }

    public synchronized int add(PDFObject pDFObject) {
        this.objects.addElement(pDFObject);
        pDFObject.objser = this.objser++;
        pDFObject.pdfDocument = this;
        if (pDFObject instanceof PDFPage) {
            this.pdfPageList.add((PDFPage)pDFObject);
        }
        return pDFObject.objser;
    }

    public PDFPage getPage(int n) {
        return this.pdfPageList.getPage(n);
    }

    public PDFOutline getOutline() {
        if (this.outline == null) {
            this.outline = new PDFOutline();
            this.catalog.setOutline(this.outline);
        }
        return this.outline;
    }

    public PDFFont getFont(String string, String string2, int n) {
        for (PDFFont pDFFont : this.fonts) {
            if (!pDFFont.equals(string, string2, n)) continue;
            return pDFFont;
        }
        ++this.fontid;
        PDFFont pDFFont = new PDFFont("/F" + this.fontid, string, string2, n);
        this.add(pDFFont);
        this.fonts.addElement(pDFFont);
        return pDFFont;
    }

    public String setImageName(PDFImage pDFImage) {
        ++this.imageid;
        pDFImage.setName("/Image" + this.imageid);
        return pDFImage.getName();
    }

    public void setPDFInfo(PDFInfo pDFInfo) {
        this.info = pDFInfo;
    }

    public PDFInfo getPDFInfo() {
        return this.info;
    }

    public void write(OutputStream outputStream) throws IOException {
        PDFOutput pDFOutput = new PDFOutput(outputStream);
        for (PDFObject pDFObject : this.objects) {
            pDFOutput.write(pDFObject);
        }
        pDFOutput.close();
        outputStream.flush();
    }
}

