/*
* JBoss, Home of Professional Open Source
* Copyright 2008, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.managed.factory.test;

import java.lang.annotation.Annotation;
import java.util.Map;

import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;
import org.jboss.managed.api.annotation.ManagementDeployment;
import org.jboss.test.managed.factory.AbstractManagedObjectFactoryTest;
import org.jboss.test.managed.factory.support.deployment.JmsDestinations;

/**
 * ManagementDeployment tests
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
public class ManagementDeploymentUnitTestCase extends AbstractManagedObjectFactoryTest
{

   public ManagementDeploymentUnitTestCase(String name)
   {
      super(name);
   }
   
   /**
    * Test that the ManagementDeployment annotation shows up on the root
    * ManagedObject
    */
   public void testManagementDeploymentonMO()
   {
      getLog().info("JmsDestinations.CS: "+JmsDestinations.class.getProtectionDomain().getCodeSource());
      Annotation[] reflectAnnotations = JmsDestinations.class.getAnnotations();
      assertEquals(2, reflectAnnotations.length);
      JmsDestinations destinations = new JmsDestinations();
      ManagedObject mo = initManagedObject(destinations);
      assertNotNull(mo);
      Map<String, Annotation> annotations = mo.getAnnotations();
      getLog().info(annotations);
      ManagementDeployment mda = (ManagementDeployment) annotations.get(ManagementDeployment.class.getName());
      assertNotNull(mda);
      assertEquals(DeploymentPhase.APPLICATION, mda.phase());
      assertEquals(1, mda.types().length);
      assertEquals("jms", mda.types()[0]);
   }

}
