/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.managed.factory.support.beans;

import java.io.Serializable;
import java.lang.annotation.Annotation;

import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/**
 * Metadata for an annotation.
 *
 * @author <a href="ales.justin@jboss.com">Ales Justin</a>
 */
public class DirectAnnotationMetaData extends JBossObject
   implements IAnnotationMetaData, Serializable
{
   private static final long serialVersionUID = 1L;

   private Annotation annotation;

   public DirectAnnotationMetaData(Annotation annotation)
   {
      if (annotation == null)
         throw new IllegalArgumentException("Null annotation");

      this.annotation = annotation;
   }

   public Annotation getAnnotationInstance()
   {
      return annotation;
   }

   public Annotation getAnnotationInstance(ClassLoader cl)
   {
      return annotation;
   }

   public void toString(JBossStringBuilder buffer)
   {
      buffer.append("annotationr=").append(annotation);
   }

   public void toShortString(JBossStringBuilder buffer)
   {
      buffer.append(annotation);
   }

   protected int getHashCode()
   {
      return annotation.hashCode();
   }

   public boolean equals(Object object)
   {
      if (object == null || object instanceof DirectAnnotationMetaData == false)
         return false;

      DirectAnnotationMetaData damd = (DirectAnnotationMetaData)object;
      return annotation.equals(damd.annotation);
   }

   public DirectAnnotationMetaData clone()
   {
      return (DirectAnnotationMetaData)super.clone();
   }
}