/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.config;

import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.EvictionPolicyConfigBase;

/**
 * This class encapsulates the configuration element for an eviction policy.
 * <p/>
 * In it's most basic form, it is implemented by {@link EvictionPolicyConfigBase}, but
 * more specific eviction policies may subclass or re-implement this interface
 * to provide access to more config variables.
 *
 * @author <a href="mailto:manik@jboss.org">Manik Surtani (manik@jboss.org)</a>
 */
public interface EvictionPolicyConfig
{
   /**
    * Gets the class name of the {@link EvictionPolicy} implementation
    * this object will configure. Used by {@link org.jboss.cache.RegionManager}
    * to instantiate the policy.
    *
    * @return fully qualified class name
    */
   String getEvictionPolicyClass();

   /**
    * Validate the configuration. Will be called after any configuration
    * properties are set.
    *
    * @throws ConfigurationException if any values for the configuration
    *                                properties are invalid
    */
   void validate() throws ConfigurationException;

   /**
    * Resets the values to their defaults.
    */
   void reset();
}
