/*
 *  @(#)IState.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.mbtf.v1;


/**
 * Associates a system state with the transitions leading out of the state,
 * and with the validation of the state.  The state object should be immutable
 * once the path generation begins.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:25 $
 * @since      June 12, 2002
 */
public interface IState
{
    /**
     * Retrieves the name for the state.  This should be unique for
     * state-machine assembly purposes, but it does not have to be.
     *
     * @return a non-null name for this state.
     */
    public String getName();
    
    
    /**
     * Retrieves the list of transitions leading from this state.
     *
     * @return a non-null list of all transitions from this state.  If the
     *      length of the list is 0, then this is a terminal state.
     */
    public ITransition[] getTransitions();
    
    
    /**
     * Retrieves the list of all validation instances used to assert that
     * the current state is valid.
     *
     * @return a non-null list of all validation instances for this state.
     *      An empty list will cause a warning on all but the first
     *      (initial) state.  This list should not include the included
     *      Transitions' validates.
     */
    public IValidate[] getValidates();
}

