/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Arguments;
import com.google.caliper.Benchmark;
import com.google.caliper.CaliperRc;
import com.google.caliper.ConfigurationException;
import com.google.caliper.ConsoleReport;
import com.google.caliper.DebugMeasurer;
import com.google.caliper.Environment;
import com.google.caliper.EnvironmentGetter;
import com.google.caliper.InProcessRunner;
import com.google.caliper.Json;
import com.google.caliper.MeasurementSet;
import com.google.caliper.MeasurementType;
import com.google.caliper.Result;
import com.google.caliper.ResultsReader;
import com.google.caliper.Run;
import com.google.caliper.Scenario;
import com.google.caliper.ScenarioResult;
import com.google.caliper.ScenarioSelection;
import com.google.caliper.UserException;
import com.google.caliper.Vm;
import com.google.caliper.VmFactory;
import com.google.caliper.runner.CaliperMain;
import com.google.caliper.util.InterleavedReader;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ObjectArrays;
import com.google.common.io.Closeables;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public final class Runner {
    private static final FileFilter UPLOAD_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".xml") || file.getName().endsWith(".json");
        }
    };
    private static final String FILE_NAME_DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ssZ";
    private static final Splitter ARGUMENT_SPLITTER = Splitter.on((Pattern)Pattern.compile("\\s+")).omitEmptyStrings();
    private Arguments arguments;
    private ScenarioSelection scenarioSelection;

    private String createFileName(Result result) {
        String timestamp = this.createTimestamp();
        return String.format("%s.%s.json", result.getRun().getBenchmarkName(), timestamp);
    }

    private String createTimestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat(FILE_NAME_DATE_FORMAT, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        dateFormat.setLenient(true);
        return dateFormat.format(new Date());
    }

    public void run(String ... args) {
        this.arguments = Arguments.parse(args);
        File resultsUploadFile = this.arguments.getUploadResultsFile();
        if (resultsUploadFile != null) {
            this.uploadResultsFileOrDir(resultsUploadFile);
            return;
        }
        this.scenarioSelection = new ScenarioSelection(this.arguments);
        if (this.arguments.getDebug()) {
            this.debug();
            return;
        }
        Result result = this.runOutOfProcess();
        new ConsoleReport(result.getRun(), this.arguments).displayResults();
        boolean saveResultsLocally = this.arguments.getSaveResultsFile() != null;
        try {
            this.postResults(result);
        }
        catch (Exception e) {
            System.out.println();
            System.out.println(e);
            saveResultsLocally = true;
        }
        if (saveResultsLocally) {
            this.saveResults(result);
        }
    }

    void uploadResultsFileOrDir(File resultsFileOrDir) {
        try {
            if (resultsFileOrDir.isDirectory()) {
                for (File resultsFile : resultsFileOrDir.listFiles(UPLOAD_FILE_FILTER)) {
                    this.uploadResults(resultsFile);
                }
            } else {
                this.uploadResults(resultsFileOrDir);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("uploading XML file failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadResults(File resultsUploadFile) throws IOException {
        System.out.println();
        System.out.println("Uploading " + resultsUploadFile.getCanonicalPath());
        FileInputStream inputStream = new FileInputStream(resultsUploadFile);
        try {
            Result result = new ResultsReader().getResult(inputStream);
            this.postResults(result);
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResults(Result result) {
        PrintStream filePrintStream;
        File destinationFile;
        File resultsFile = this.arguments.getSaveResultsFile();
        if (resultsFile == null) {
            File dir = new File("./caliper-results");
            dir.mkdirs();
            destinationFile = new File(dir, this.createFileName(result));
        } else if (resultsFile.exists() && resultsFile.isDirectory()) {
            destinationFile = new File(resultsFile, this.createFileName(result));
        } else {
            File parent = resultsFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            destinationFile = resultsFile;
        }
        try {
            filePrintStream = new PrintStream(new FileOutputStream(destinationFile));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("can't open " + destinationFile, e);
        }
        String resultJson = Json.getGsonInstance().toJson((Object)result);
        try {
            System.out.println();
            System.out.println("Writing results to " + destinationFile.getCanonicalPath());
            filePrintStream.print(resultJson);
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("Failed to write results to file, writing to standard out instead:");
            System.out.println(resultJson);
            System.out.flush();
        }
        finally {
            filePrintStream.close();
        }
    }

    private void postResults(Result result) {
        CaliperRc caliperrc = CaliperRc.INSTANCE;
        String postUrl = caliperrc.getPostUrl();
        String apiKey = caliperrc.getApiKey();
        if (postUrl == null || apiKey == null) {
            return;
        }
        try {
            String line;
            URL url = new URL(postUrl + apiKey + "/" + result.getRun().getBenchmarkName());
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(this.getProxy());
            urlConnection.setDoOutput(true);
            String resultJson = Json.getGsonInstance().toJson((Object)result);
            urlConnection.getOutputStream().write(resultJson.getBytes());
            if (urlConnection.getResponseCode() == 200) {
                System.out.println("");
                System.out.println("View current and previous benchmark results online:");
                BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                System.out.println("  " + in.readLine());
                in.close();
                return;
            }
            System.out.println("Posting to " + postUrl + " failed: " + urlConnection.getResponseMessage());
            BufferedReader reader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Posting to " + postUrl + " failed.", e);
        }
    }

    private Proxy getProxy() {
        String proxyAddress = CaliperRc.INSTANCE.getProxy();
        if (proxyAddress == null) {
            return Proxy.NO_PROXY;
        }
        String[] proxyHostAndPort = proxyAddress.trim().split(":");
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHostAndPort[0], Integer.parseInt(proxyHostAndPort[1])));
    }

    private ScenarioResult runScenario(Scenario scenario) {
        MeasurementResult timeMeasurementResult = this.measure(scenario, MeasurementType.TIME);
        MeasurementSet allocationMeasurements = null;
        String allocationEventLog = null;
        MeasurementSet memoryMeasurements = null;
        String memoryEventLog = null;
        if (this.arguments.getMeasureMemory()) {
            MeasurementResult allocationsMeasurementResult = this.measure(scenario, MeasurementType.INSTANCE);
            allocationMeasurements = allocationsMeasurementResult.getMeasurements();
            allocationEventLog = allocationsMeasurementResult.getEventLog();
            MeasurementResult memoryMeasurementResult = this.measure(scenario, MeasurementType.MEMORY);
            memoryMeasurements = memoryMeasurementResult.getMeasurements();
            memoryEventLog = memoryMeasurementResult.getEventLog();
        }
        return new ScenarioResult(timeMeasurementResult.getMeasurements(), timeMeasurementResult.getEventLog(), allocationMeasurements, allocationEventLog, memoryMeasurements, memoryEventLog);
    }

    private MeasurementResult measure(Scenario scenario, MeasurementType type) {
        Process timeProcess;
        Vm vm = new VmFactory().createVm(scenario);
        ProcessBuilder processBuilder = this.createCommand(scenario, vm, type).redirectErrorStream(true);
        try {
            timeProcess = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("failed to start subprocess", e);
        }
        MeasurementSet measurementSet = null;
        StringBuilder eventLog = new StringBuilder();
        InterleavedReader reader = null;
        try {
            Object o;
            reader = new InterleavedReader(this.arguments.getMarker(), new InputStreamReader(timeProcess.getInputStream()));
            while ((o = reader.read()) != null) {
                if (o instanceof String) {
                    eventLog.append(o);
                    continue;
                }
                if (measurementSet == null) {
                    JsonObject jsonObject = (JsonObject)o;
                    measurementSet = Json.measurementSetFromJson(jsonObject);
                    continue;
                }
                throw new RuntimeException("Unexpected value: " + o);
            }
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                timeProcess.destroy();
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
        timeProcess.destroy();
        if (measurementSet == null) {
            String message = "Failed to execute " + Joiner.on((String)" ").join(processBuilder.command());
            System.err.println("  " + message);
            System.err.println(eventLog.toString());
            throw new ConfigurationException(message);
        }
        return new MeasurementResult(measurementSet, eventLog.toString());
    }

    private ProcessBuilder createCommand(Scenario scenario, Vm vm, MeasurementType type) {
        File workingDirectory = new File(System.getProperty("user.dir"));
        String classPath = System.getProperty("java.class.path");
        if (classPath == null || classPath.length() == 0) {
            throw new IllegalStateException("java.class.path is undefined in " + System.getProperties());
        }
        ImmutableList.Builder vmArgs = ImmutableList.builder();
        vmArgs.addAll(ARGUMENT_SPLITTER.split((CharSequence)scenario.getVariables().get("vm")));
        if (type == MeasurementType.INSTANCE || type == MeasurementType.MEMORY) {
            String allocationJarFile = System.getenv("ALLOCATION_JAR");
            vmArgs.add((Object)("-javaagent:" + allocationJarFile));
        }
        vmArgs.addAll(vm.getVmSpecificOptions(type, this.arguments));
        Map<String, String> vmParameters = scenario.getVariables(this.scenarioSelection.getVmParameterNames());
        for (String vmParameter : vmParameters.values()) {
            vmArgs.addAll(ARGUMENT_SPLITTER.split((CharSequence)vmParameter));
        }
        ImmutableList.Builder caliperArgs = ImmutableList.builder();
        caliperArgs.add((Object)"--warmupMillis").add((Object)Long.toString(this.arguments.getWarmupMillis()));
        caliperArgs.add((Object)"--runMillis").add((Object)Long.toString(this.arguments.getRunMillis()));
        caliperArgs.add((Object)"--measurementType").add((Object)type.toString());
        caliperArgs.add((Object)"--marker").add((Object)this.arguments.getMarker());
        Map<String, String> userParameters = scenario.getVariables(this.scenarioSelection.getUserParameterNames());
        for (Map.Entry<String, String> entry : userParameters.entrySet()) {
            caliperArgs.add((Object)("-D" + entry.getKey() + "=" + entry.getValue()));
        }
        caliperArgs.add((Object)this.arguments.getSuiteClassName());
        return vm.newProcessBuilder(workingDirectory, classPath, (ImmutableList<String>)vmArgs.build(), InProcessRunner.class.getName(), (ImmutableList<String>)caliperArgs.build());
    }

    private void debug() {
        try {
            int debugReps = this.arguments.getDebugReps();
            InProcessRunner runner = new InProcessRunner();
            DebugMeasurer measurer = new DebugMeasurer(debugReps);
            for (Scenario scenario : this.scenarioSelection.select()) {
                System.out.println("running " + debugReps + " debug reps of " + scenario);
                runner.run(this.scenarioSelection, scenario, measurer);
            }
        }
        catch (Exception e) {
            throw new UserException.ExceptionFromUserCodeException(e);
        }
    }

    private Result runOutOfProcess() {
        Date executedDate = new Date();
        ImmutableMap.Builder resultsBuilder = ImmutableMap.builder();
        try {
            List<Scenario> scenarios = this.scenarioSelection.select();
            int i = 0;
            for (Scenario scenario : scenarios) {
                this.beforeMeasurement(i++, scenarios.size(), scenario);
                ScenarioResult scenarioResult = this.runScenario(scenario);
                this.afterMeasurement(this.arguments.getMeasureMemory(), scenarioResult);
                resultsBuilder.put((Object)scenario, (Object)scenarioResult);
            }
            System.out.println();
            Environment environment = new EnvironmentGetter().getEnvironmentSnapshot();
            return new Result(new Run((Map<Scenario, ScenarioResult>)resultsBuilder.build(), this.arguments.getSuiteClassName(), executedDate), environment);
        }
        catch (Exception e) {
            throw new UserException.ExceptionFromUserCodeException(e);
        }
    }

    private void beforeMeasurement(int index, int total, Scenario scenario) {
        double percentDone = (double)index / (double)total;
        System.out.printf("%2.0f%% %s", percentDone * 100.0, scenario);
    }

    private void afterMeasurement(boolean memoryMeasured, ScenarioResult scenarioResult) {
        String memoryMeasurements = "";
        if (memoryMeasured) {
            MeasurementSet instanceMeasurementSet = scenarioResult.getMeasurementSet(MeasurementType.INSTANCE);
            String instanceUnit = (String)((Map.Entry)ConsoleReport.UNIT_ORDERING.min(instanceMeasurementSet.getUnitNames().entrySet())).getKey();
            MeasurementSet memoryMeasurementSet = scenarioResult.getMeasurementSet(MeasurementType.MEMORY);
            String memoryUnit = (String)((Map.Entry)ConsoleReport.UNIT_ORDERING.min(memoryMeasurementSet.getUnitNames().entrySet())).getKey();
            memoryMeasurements = String.format(", allocated %s%s for a total of %s%s", Math.round(instanceMeasurementSet.medianUnits()), instanceUnit, Math.round(memoryMeasurementSet.medianUnits()), memoryUnit);
        }
        MeasurementSet timeMeasurementSet = scenarioResult.getMeasurementSet(MeasurementType.TIME);
        String unit = (String)((Map.Entry)ConsoleReport.UNIT_ORDERING.min(timeMeasurementSet.getUnitNames().entrySet())).getKey();
        System.out.printf(" %.2f %s; \u03c3=%.2f %s @ %d trials%s%n", timeMeasurementSet.medianUnits(), unit, timeMeasurementSet.standardDeviationUnits(), unit, timeMeasurementSet.getMeasurements().size(), memoryMeasurements);
    }

    public static void main(String[] args) {
        try {
            new Runner().run(args);
            System.exit(0);
        }
        catch (UserException.DisplayUsageException e) {
            e.display();
            System.exit(0);
        }
        catch (UserException e) {
            e.display();
            System.exit(1);
        }
    }

    public static void main(Class<? extends Benchmark> suite, String[] args) {
        String env = System.getenv("USE_CANARY_CALIPER");
        if (env != null && !env.isEmpty()) {
            CaliperMain.main(suite, args);
        } else {
            Runner.main((String[])ObjectArrays.concat((Object[])args, (Object)suite.getName()));
        }
    }

    private static class MeasurementResult {
        private final MeasurementSet measurements;
        private final String eventLog;

        MeasurementResult(MeasurementSet measurements, String eventLog) {
            this.measurements = measurements;
            this.eventLog = eventLog;
        }

        public MeasurementSet getMeasurements() {
            return this.measurements;
        }

        public String getEventLog() {
            return this.eventLog;
        }
    }
}

