/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DetachVolume
extends BaseCmd {
    private static final String[] FORCE_DESC = new String[]{"Forcefully disconnect VOLUME from INSTANCE.", "WARNING: This can lead to data loss or a corrupted file system.", "         Use this option only as a last resort to detach a volume", "         from a failed instance.  The instance will not have an", "         opportunity to flush file system caches nor file system", "         meta data."};
    private static final String[] DEVICE_DESC = new String[]{"A device name as which the VOLUME is exposed inside INSTANCE."};
    private static final String[] INSTANCE_DESC = new String[]{"The running instance to which the volume is attached."};

    public DetachVolume(String[] args) {
        super("ec2detvol", "ec2-detach-volume");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(DetachVolume.createOptionWithArgs("i", "instance", INSTANCE_DESC, "INSTANCE"));
        result.addOption(DetachVolume.createOptionWithArgs("d", "device", DEVICE_DESC, "DEVICE"));
        result.addOption(DetachVolume.createOption("f", "force", FORCE_DESC));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "VOLUME [-i INSTANCE [-d DEVICE]] [-f|--force]";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Detach an attached volume, forcefully if indicated, from the specified instance.");
        System.out.println("     The VOLUME parameter specifies the volume which to detach.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("instance");
        this.printOption("device");
        this.printOption("force");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("VOLUME");
        if (this.isOptionSet("device")) {
            this.assertOptionSet("instance");
        }
        this.warnIfTooManyNonOptions();
        String volume = this.getNonOptions()[0];
        String instance = this.getOptionValue("instance");
        String device = this.getOptionValue("device");
        Boolean force = this.isOptionSet("force");
        RequestResultPair rsp = jec2.detachVolume(volume, instance, device, force);
        if (rsp != null) {
            out.output(System.out, (AttachmentDescription)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DetachVolume(args).invoke();
    }
}

