/* Definitions common to all AIs.
   Copyright (C) 1992-1997, 1999 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

typedef enum {
    nobrains = 0,
    mplayertype = 1
    /* plus other types as defined */
#ifdef MPW_C
    /* Works around an MPW C bug where byte-sized enums lose - symptom
       is that AIs never do anything. */
    , aitype_intifier = 1000000
#endif /* MPW_C */
} AIType;

typedef struct a_ai_op {
    char *name;
    int (*to_test_compat)(void);
    void (*to_init)(Side *side);
    void (*to_init_turn)(Side *side);
    void (*to_decide_plan)(Side *side, Unit *unit);
    void (*to_react_to_action_result)(Side *side, Unit *unit,
					      int rslt);
    void (*to_react_to_task_result)(Side *side, Unit *unit,
					    Task *task, TaskOutcome rslt);
	void (*to_react_to_new_side)(Side *side, Side *side2);
    int (*to_adjust_plan)(Side *side, Unit *unit);
    /* Called before execution to ensure the plan is up-to-date. */
    int (*to_update_plan)(Unit *unit);
    /* Called just before execution to deal with emergencies. */
    int (*to_handle_emergency)(Unit *unit);
    void (*to_finish_movement)(Side *side);
    void (*to_receive_message)(Side *side, Side *sender, char *str);
    Obj *(*to_save_state)(Side *side);
    int (*region_at)(Side *side, int x, int y);
    char *(*at_desig)(Side *side, int x, int y);
    int dummy;
} AI_ops;

/* Definition common to all ai types. (?) */

typedef struct a_ai {
  int dummy;
} AI;

#define side_ai_type(s) ((s)->aitype)

/* Add declaration of AI hooks here. */

extern void init_ai_types(void);
extern void init_ai(Side *side);
extern void ai_init_turn(Side *side);
extern void ai_decide_plan(Side *side, Unit *unit);
extern void ai_react_to_action_result(Side *side, Unit *unit,
					      int rslt);
extern void ai_react_to_task_result(Side *side, Unit *unit,
					    Task *task, TaskOutcome rslt);
extern void ai_react_to_new_side(Side *side, Side *side2);
extern int ai_adjust_plan(Side *side, Unit *unit);
extern void ai_finish_movement(Side *side);
extern void ai_receive_message(Side *side, Side *sender, char *str);
extern void ai_save_state(Side *side);
extern int ai_region_at(Side *side, int x, int y);
extern char *ai_at_desig(Side *side, int x, int y);

extern int ai_update_plan(Side *side, Unit *unit);
extern int ai_handle_emergency(Side *side, Unit *unit);

extern void ai_init_shared(void);
extern int basic_worth(int u);
extern int offensive_worth(int u);
extern int defensive_worth(int u);
extern int exploring_worth(int u);
extern int colonizing_worth(int u);
extern int facility_worth(int u);
extern int random_worth(int u);
extern int siege_worth(int u);

extern int basic_hit_worth(int u, int e);
extern int basic_fire_worth(int u, int e);
extern int basic_capture_worth(int u, int e);
extern int basic_transport_worth(int u, int e);
extern int unit_strength(int u);
extern void display_assessment(void);

extern int is_base_for(int u1, int u2);
extern int is_carrier_for(int u1, int u2);

extern void set_u_is_base(int u, int n);
extern void set_u_is_transport(int u, int n);
extern void set_u_is_carrier(int u, int n);
extern void set_u_is_base_builder(int u, int n);
extern void set_u_can_make(int u, int n);
extern void set_u_can_capture(int u, int n);
extern void set_u_bw(int u, int n);

extern void set_u_offensive_worth(int u, int n);
extern void set_u_defensive_worth(int u, int n);
extern void set_u_explorer_worth(int u, int n);
extern void set_u_colonizer_worth(int u, int n);
extern void set_u_facility_worth(int u, int n);
extern void set_u_random_worth(int u, int n);
extern void set_u_siege_worth(int u, int n);

extern void set_u_is_ground_mobile(int u, int n);
extern void set_u_is_naval_mobile(int u, int n);
extern void set_u_is_air_mobile(int u, int n);
extern void set_u_is_advanced(int u, int n);
extern void set_u_is_colonizer(int u, int n);
extern void set_u_is_facility(int u, int n);
	
extern void set_uu_bhw(int u1, int u2, int v);
extern void set_uu_bfw(int u1, int u2, int v);
extern void set_uu_bcw(int u1, int u2, int v);
extern void set_uu_btw(int u1, int u2, int v);
