(game-module "standard"
  (title "Standard Game")
  (blurb "The standard Xconq game, loosely based on WW II ca 1945")
  (instructions "Take over the world before you get taken over!")
  (variants
    (world-seen false)
    (see-all false)
    (world-size (60 30 360))
    (sequential false)
    ("Mostly Land" mostly-land
      (true
        ;; Adjust so that sea is 20% instead of 70% of the world.
        (add sea alt-percentile-max 20)
        (add shallows alt-percentile-min 20)
        (add shallows alt-percentile-max 21)
        (add swamp alt-percentile-min 21)
        (add swamp alt-percentile-max 23)
        (add (desert plains forest) alt-percentile-min 21)
        ))
    ("All Land" all-land
      (true
        ;; Adjust sea and shallows out of existence, let swamp take all the low spots.
        (add sea alt-percentile-min 0)
        (add sea alt-percentile-max 0)
        (add shallows alt-percentile-min 0)
        (add shallows alt-percentile-max 0)
        (add swamp alt-percentile-min 0)
        (add swamp alt-percentile-max 2)
        (add swamp wet-percentile-min 0)
        (add swamp wet-percentile-max 100)
        (add (desert plains forest) alt-percentile-min 2)
        ;; Counterproductive to try to set up near water.
		(add sea country-terrain-min 0)
        ))
    ("Large Countries" large
     (true
       ;; This is the same as country separation.
       (set country-radius-max 48)
       (add (town city) unit-growth-chance (100 20))
       (add (town city) independent-growth-chance (20 0))
       ))
    ("Noisy" noisy
     (true
       (set action-movies '(
         (move (sound "pop"))
         ))

       (set event-movies '(
         (side-lost (sound "thunder"))
         (unit-captured (sound "chirr"))
         (unit-completed (sound "chirr"))
         (unit-moved (sound "pop 2"))
         ))
       ))
    )
  )

(include "stdunit")

(include "nat-names")

(include "town-names")

(add (* @) namer "random-town-names")

(set default-namer "random-town-names")

(set feature-types '(peak island lake bay))

(set feature-namers
  '((island generic-island-names) (lake generic-lake-names) (bay generic-bay-names)))

(namer generic-island-names (grammar root 10
  (root (or 1 (foo "Ile d'" short-generic-names)
            2 (short-generic-names " Isle")
            10 (short-generic-names " Island")
            ))
  (foo "")  ; works around a bug
  ))

(namer generic-lake-names (grammar root 10
  (root (or 5 (foo "Lake " short-generic-names)
            1 (short-generic-names " Lake")
            ))
  (foo "")  ; works around a bug
  ))

(namer generic-bay-names (grammar root 10
  (root (or 1 (foo "Bay of " short-generic-names)
            5 (short-generic-names " Bay")
            ))
  (foo "")  ; works around a bug
  ))

(include "ng-weird")

(set advantage-min 1)
(set advantage-default 1)
(set advantage-max 5)

(scorekeeper
  (title "")
  (do last-side-wins)
  )

(set scorefile-name "standard.xcq")

(add u* see-terrain-if-captured 10)
(add town see-terrain-if-captured 50)
(add city see-terrain-if-captured 100)

(table see-others-if-captured
  (ship ship 50)
  (base u* 10)
  (town u* 20)
  (town (town city) 100)
  (city u* 100)
  )
