Summary: Valgrind Memory Debugger
Name: valgrind
Version: 2.1.1
Release: 1
Copyright: GPL
Group: Development/Debuggers
Packager: Jeremy Fitzhardinge <jeremy@goop.org>
Source: valgrind-2.1.1.tar.bz2

Buildroot: %{_tmppath}/valgrind

%description 

Valgrind is a GPL'd system for debugging and profiling x86-Linux programs.
With the tools that come with Valgrind, you can automatically detect
many memory management and threading bugs, avoiding hours of frustrating
bug-hunting, making your programs more stable. You can also perform
detailed profiling to help speed up your programs.

The Valgrind distribution includes four tools: two memory error
detectors, a thread error detector, and a cache profiler.  Several other
tools have been built with Valgrind.

%prep
%setup -n valgrind-2.1.1

%build
./configure --prefix=/usr
make

%install
make install DESTDIR=$RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/include/valgrind/valgrind.h
/usr/include/valgrind/memcheck.h
/usr/include/valgrind/helgrind.h
/usr/include/valgrind/vg_constants_skin.h
/usr/include/valgrind/vg_kerneliface.h
/usr/include/valgrind/vg_skin.h
/usr/bin/valgrind
/usr/bin/cg_annotate
/usr/lib/valgrind
/usr/lib/valgrind/*
/usr/bin/valgrind-listener
/usr/lib/pkgconfig/valgrind.pc

%doc
/usr/share/doc/valgrind/*

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}
