#include <stdio.h>

#define _GEN_OFFSETS
#include "core.h"

int main(int argc, char **argv)
{
   printf("/* Generated by %s */\n\n", argv[0]);
   printf("#ifndef __CORE_ARCH_ASM_OFFSETS_H\n");
   printf("#define __CORE_ARCH_ASM_OFFSETS_H\n\n");

   printf("/* offset of payload in TCEntry */\n");
   printf("#define VG_CODE_OFFSET	%d\n", offsetof(TCEntry, payload));

   printf("\n/* offset of dispatch_ctr in ThreadState */\n");
   printf("#define VGOFF_DISPATCH_CTR	%d\n", offsetof(ThreadState, dispatch_ctr));

   /* register offsets into struct ThreadState */
   printf("\n/* register offsets in ThreadState */\n");
#define RO(reg) printf("#define VGOFF_%s	%d\n", #reg, offsetof(ThreadState, arch.m_##reg))
   RO(gpr);
   RO(eip);
   RO(ctr);
   RO(lr);
   RO(xer);
   RO(cr);
   RO(orig_gpr3);
   RO(result);
   RO(fpr);
   RO(vr);
#undef RO
   printf("#define VGOFF_vr_live	%d\n", offsetof(ThreadState, arch.vr_live));
   printf("#define VGOFF_dispatch_sp	%d\n", offsetof(ThreadState, arch.dispatch_sp));

   printf("\n#endif /* __CORE_ARCH_ASM_OFFSETS_H */\n");

   return 0;
}
