
/*--------------------------------------------------------------------*/
/*--- A header file containing architecture-specific constants     ---*/
/*--- for Valgrind on PowerPC-architecture processors.		   ---*/
/*---                                               vg_archconst.h ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, an extensible
   emulator for monitoring program execution on Unixes.

   Copyright (C) 2000-2004 Julian Seward 
      jseward@acm.org
   Copyright (C) 2004 Paul Mackerras
      paulus@samba.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#ifndef __VG_ARCHCONST_H
#define __VG_ARCHCONST_H

/* This file is included in all Valgrind source files, including
   assembly ones. */

/* size of call instruction put into generated code at jump sites */
#define VG_PATCHME_CALLSZ	4

/* size of jmp instruction which overwrites the call */
#define VG_PATCHME_JMPSZ	4

/* maximum number of normal jumps which can appear in a basic block */
#define VG_MAX_JUMPS		4

/* Offset of code in a TCEntry */
#define VG_CODE_OFFSET		(12 + VG_MAX_JUMPS * 2)

/* Minimum size of an instruction, in bytes */
#define INSTR_MIN_SIZE		4

/* These offsets are used in assembly code on PowerPC */
#define BBOFF_GPR	0
#define BBOFF_EIP	128
#define BBOFF_CR	132
#define BBOFF_XER	144

#endif /* __VG_ARCHCONST_H */
