extern char end;
extern char *sbrk(int incr);
extern int brk(const char *addr);

main()
{
  char *broke;
  int status;
  int failure = 0;

  if (((unsigned long)&end & 0x7) != 0) {
    write_string("end not 8 byte aligned (error?)");
    write_line();
    failure += 1;
  }


  write_string("Calling sbrk(0)");
  write_line();
  write_string("\t");
  broke = sbrk(0);
  write_string("sbrk(0) = 0x");
  write_hex(broke);
  write_string(", end=0x");
  write_hex(&end);
  if (broke == &end)
    write_string(" (ok)");
  else {
    write_string(" (error?)");
    failure += 1;
  }
  write_line();

  write_string("Calling sbrk(0)");
  write_line();
  write_string("\t");
  broke = sbrk(0);
  write_string("sbrk(0) = 0x");
  write_hex(broke);
  write_string(", end=0x");
  write_hex(&end);
  if (broke == &end)
    write_string(" (ok)");
  else {
    write_string(" (error?)");
    failure += 1;
  }
  write_line();

  write_string("Calling sbrk(0x1000)");
  write_line();
  write_string("\t");
  broke = sbrk(0x1000);
  write_string("sbrk(0x1000) = 0x");
  write_hex(broke);
  if (broke == &end)
    write_string(" (ok)");
  else {
    write_string(" (error? != 0x");
    write_hex(&end);
    write_string(")");
    failure += 1;
  }
  *broke = *broke;
  write_line();
  write_string("\t");
  broke = sbrk(0);
  write_string("sbrk(0) = 0x");
  write_hex(broke);
  if (broke == &end + 0x1000)
    write_string(" (ok)");
  else {
    write_string(" (error? != ");
    write_hex(&end + 0x1000);
    write_string(")");
    failure += 1;
  }
  write_line();
  
  write_string("Calling brk(sbrk(0)))");
  write_line();
  write_string("\t");
  status = brk(sbrk(0));
  write_string("brk(sbrk(0)) = ");
  write_unsigned(status);
  write_line();
  broke = sbrk(0);
  write_string("\t");
  write_string("sbrk(0) = 0x");
  write_hex(broke);
  if (broke == &end + 0x1000)
    write_string(" (ok)");
  else {
    write_string(" (error? != ");
    write_hex(&end + 0x1000);
    write_string(")");
    failure += 1;
  }
  *broke = *broke;
  write_line();
  
  write_string("Calling brk(sbrk(0)+1))");
  write_line();
  status = brk(sbrk(0)+1);
  write_string("brk(sbrk(0)) = ");
  write_unsigned(status);
  write_string("(0x");
  write_hex(sbrk(0));
  write_string(")");
  write_line();
  *broke = *broke;
  
  if (failure) {
    write_int(failure);
    write_string(" failures");
    write_line();
  }
  return failure > 0;
}

static long long make_end_8_byte_aligned;

