typedef unsigned vm_size_t;
#define PANIC_IT(X)

PANIC_IT(pmap_phys_address)
PANIC_IT(pmap_clear_modify)
PANIC_IT(pmap_clear_reference)
PANIC_IT(pmap_pageable)
PANIC_IT(pmap_change_wiring)
PANIC_IT(pmap_page_protect)
PANIC_IT(pmap_extract)
PANIC_IT(pmap_init)
PANIC_IT(pmap_protect)
PANIC_IT(pmap_copy)
PANIC_IT(pmap_bootstrap_alloc)
PANIC_IT(pmap_update)
/*vm_offset_t*/unsigned avail_start;
/*vm_offset_t*/unsigned avail_end;
/*vm_offset_t*/unsigned virtual_end;
/*vm_offset_t*/unsigned virtual_avail;
/*pmap_t*/unsigned kernel_pmap;
#include "../code/bits.h"


/* PowerPC hash table.  It consists of 64bit pte's grouped together in
   blocks of 8 to form a pte-group.  An array of these groups makes up
   the hash table.

   To simplify access.  htab is defined as a union of both ptes and
   pteg's */

typedef enum {
  nr_ptes_per_pteg = 8
} htab_constants;

typedef unsigned pte_t[2];
typedef pte_t pteg_t[nr_pte_per_pteg];

typedef union _htab_t {
  pte_t pte[1];
  pteg_t pteg[1];
} htab_t;

static htab_t *htab;

/* simple functions to extract out the various fields of a pte entry */

static unsigned
pte_valid_bit(pte_t pte)
{
  return EXTRACTED32(pte[0], 0, 0);
}

static vsid_t
pte_virtual_segment_id_bits(pte_t pte)
{
  return EXTRACTED32(pte[0], 1, 24);
}

static unsigned
pte_hash_function_identifier_bit(pte_t pte)
{
  return EXTRACTED32(pte[0], 25, 25);
}

static unsigned
pte_appreviated_page_index_bits(pte_t pte)
{
  return EXTRACTED32(pte[0], 26, 31);
}

static unsigned
pte_real_page_number_bits(pte_t pte)
{
  return EXTRACTED32(pte[1], 0, 19);
}

static unsigned
pte_reference_bit(pte_t pte)
{
  return EXTRACTED32(pte[1], 23, 23);
}

static unsigned
pte_change_bit(pte_t pte)
{
  return EXTRACTED32(pte[1], 24, 24);
}

static unsigned
pte_storage_access_control_bits(pte_t pte)
{
  return EXTRACTED32(pte[1], 25, 28);
}

static unsigned
pte_page_protection_bits(pte_t pte)
{
  return EXTRACTED32(pte[1], 29, 31);
}


static unsigned
pte_ea_page(pte_t pte, int htab_index)
{
  unsigned hash;
  if (pte_hash_function_identifier(pte)) {
    hash = htab_index;
  }
  else {
    hash = ~htab_index;
  }
  return ((pte_appreviated_page_index(pte) << 10)
	  | MASKED32(hash ^ pte_vsid(pte), 22, 31));
}


/* congurent to the hardware htab is the annex structure that contains
   all the data structures for pmap management.  The pte index is used
   as the common key.

   The annex stores two key structues: A single linked list of pte's
   pointing to the one page; A double linked list of pte's that are
   members of a given pmap. */

typedef struct _pte_annex_t {
  int next_page_pte;
  int next_pmap_pte;
  int last_pmap_pte;
  char is_wired;
  char is_first_pmap_pte; /* 1: pmap_pte_last == &pmap->first_pte_index */
  char lru; /* keep track of pte's allocation: 0(mru) .. 7 (lru) */
  char h;
} pte_annex_t;

typedef struct _pteg_annex_t {
  pte_annex_t pte[nr_pte_per_pteg];
} pteg_annex_t;

typedef struct _htab_annex_t {
  pte_annex_t pte[1];
  pteg_annex_t pteg[1];
} htab_annex_t;

static htab_annex_t *annex;


/* for each physical page, a table contains the first of the list of
   pte's that refer to it. */

typedef struct _page_t {
  int first_pte;
} page_t;

static page_t *page;

static address_type
init_page(address_type top_of_memory, int nr_pages)
{
  page = (page_t*)top_of_memory;
  return top_of_memory+sizeof(page_t)*nr_pages;
}




/* structure to keep track of which VSID's are currently free.  Here
   we pre-allocate VSID's in sequential groups of 16.  These groups
   correspond to the top 4 bits of a 32 bit effective address.
   Accordingly, the table below only needs to keep track of the
   allocation of a 20 bit vsid not the normal 24bit one */

typedef unsigned vsid_t;

typedef enum {
  first_vsid = 0x10; /* 0..0xf reserved for the kernel */
  last_vsid = 0xfffff0; /* 0xfffff0 is reserved for Open Firmware */
} vsid_constants;

typedef struct _vsid_heap_t {
  vsid_t most_recent;
  unsigned *free_heap;
} vsid_heal_t;   

static vsid_heap_t vsid_heap;

static int
vsid_free_heap_index(vsid_t vsid)
{
  return ((vsid >> 4) >> 32);
}

static unsigned
vsid_free_heap_mask(vsid_t vsid)
{
  return (1 << ((vsid >> 4) & (32 - 1)));
}

static void
free_vsid(vsid_t vsid)
{
  vsid_heap.free_heap[vsid_free_heap_index(vsid)] |= vsid_free_heap_mask(vsid);
}


static vsid_t
alloc_vsid(void)
{
  vsid_t new_vsid = vsid_heap.most_recent;
  do {
    new_vsid += (1 << 4);
    if (new_vsid >= last_vsid) {
      new_vsid = first_vsid;
      FIXME_wrapped vsid_could_need_to_flush_all();
    }
    if (vsid_heap.free_heap[vsid_free_heap_index(new_vsid)]
	& vsid_free_heap_mask(new_vsid)) {
      vsid_heap.most_recent = new_vsid;
      return new_vsid;
    }
  } while (new_vsid != vsid_heap.most_recent);
  
  panic("vsid heap overflow");
}

static address_type
init_vsid_heap(address_type top_of_memory)
{
  /* need to allocate enough space for 2^(24 - 4) bits == 2^20 bits
     == 2^20 / 2^5 * 2^5 == 2^15 * 2^5 == 32k words */
  vsid_heap.free_heap = (unsigned*)top_of_memory;
  return top_of_memory + (1 << 15);
}


/* finally, the pmap structure lives somewhere ... */
typedef struct _pmap_t {
  int first_pte_index; /* indexs htab->pte[] && htab_annex->pte[] */
  unsigned vsid_base; /* VSID's vsid .. vsid + 0xf0.. allocated */
  simple_lock_data_t lock; /* something wants this ... */
  int count;
} *pmap_t;


int
find_htab_pte(vsid_t vsid,
	      unsigned real_page_nr,
	      unsigned ea_page,
	      int allocate_free)
{
  hash = pa^vsid;
  for (h = 0; h < 2; h++) {
    htab_index = hash & htab_mask;
    pteg = &htab.pteg[htab_index];
    for (pteg_index = 0; pteg_index < nr_pte_per_pteg; pteg_index++) {
      pte_t *pte = pteg[pteg_index];
      if (pte_valid_bit(pte)) {
	/* pte in use ... */
	if (pte_vsid(pte) == vsid
	    && pte_real_page_number(pte) == pa
	    && pte_ea_page(pte, htab_index) == va) {
	  /* already entered */
	  return htab_index * nr_pte_per_pteg + pteg_index;
	}
	else if (htab_annex.pteg[htab_index][pte_index].wired) {
	  /* oops, can't touch this one */
	  continue;
	}
	else if (alloc_pte_lru
		 < htab_annex.pteg[htab_index][pte_index].lru) {
	  /* remember this one, could re-use it */
	  alloc_pte_lru = htab_annex.pteg[htab_index][pte_index].lru;
	  alloc_pte = htab_index * nr_pte_per_pteg + pteg_index;
	  alloc_pte_h = h;
	}
      }
      else {
	/* pte free, allocate it if we haven't allocated a free pte
           yet */
	if (alloc_pte_lru < nr_pte_per_pteg) {
	  alloc_pte = htab_index * nr_pte_per_pteg + pteg_index;
	  alloc_pte_lru = nr_pte_per_pteg;
	  alloc_pte_h = h;
	}
      }
    }
    hash = ~hash;
  }

  
  /* return something */
  if (allocate_free) {
    /* just hope this never happens */
    if (alloc_pte_lru < 0)
      panic("htab overflow");
    htab_annex.pte[alloc_pte].h = alloc_pte_h;
    return alloc_pte;
  }
  else {
    return -1; /* not found */
  }
}


void
update_htab_pte(int pte_index,
		something real_page_nr,
		int ea_page,
		int prot)
{
  /* flush any old pte if it is valid */
  /* update real entry */
  /* insert any new entry into lists */
}



/* check/create a htab structure and it's annex.  The current `top' of
   heap is passed in.  The new top of heap is returned.  It is assumed
   that all memory is mapped 1:1 and 0xe+1..1 and that the latter will
   always be there.  Further, base is a pointer into the 0xe+1 address range */

/* mumble something here about setting up the kernel map */

void *
vm_init(void *base, int nr_ptes, int nr_pages)
{
  char *end_of_vm_data = (char*)base;

  /* the htab */
  htab = (htab_t*)end_of_vm_data;
  end_of_vm_data = (char*)(&htab->pte[nr_ptes]);

  /* the annex */
  htab_annex = (htab_annex_t*)end_of_vm_data;
  end_of_vm_data = (char*)(&htab_annex->pte[nr_ptes]);

  /* the page structure */
  page = (page_t*)end_of_vm_data;
  end_of_vm_data = (char*)(&page[nr_pages]);

  /* the vsid structure */
  FIXME();

  /* the pmap structure */
  /* the allocation of space for pmap's is someone elses problem */
}



/* init the specified pmap */
void
pmap_pinit(pmap_t pmap)
{
  int next_vsid = vsid_table.last_vsid;
  int vsid_index;
  unsigned vsid_mask;

  /* allocate a vsid for this PMAP */
  vsid_index = alloc_vsid();
  pmap->vsid = next_vsid;

  /* the list of member pte's is empty */
  pmap->first_pte_index = -1;

  /* locks? */
}


/* based on the alpha ... */
pmap_t
pmap_create(vm_size_t size)
{
  pmap_t new_pmap;

  /* see the notes.  Only concerned with physical pmap's */
  if (size != 0)
    return (NULL);

  /* allocate it */
  pmap = (pmap_t) malloc(sizeof(*pmap), M_VMPMAP, M_WAITOK);
  if (pmap == NULL)
    panic("pmap_create: malloc of pmap failed");

  /* init it */
  bzero(pmap, sizeof(*pmap));
  pmap_pinit(pmap);

  return pmap;
}


/* (from alpha)
 *	Add a reference to the specified pmap.
 */
void
pmap_reference(pmap)
	pmap_t pmap;
{
  if (pmap != NULL) {
    simple_lock(&pmap->pm_lock);
    pmap->pm_count++;
    simple_unlock(&pmap->pm_lock);
  }
}


/*
 * Release any resources held by the given physical map.
 * Called when a pmap initialized by pmap_pinit is being released.
 * Should only be called if the map contains no valid mappings.
 */
void
pmap_release(pmap_t pmap)
{

  /* are we sane */
  if (pmap == NULL)
    panic("pmap_release: null pmap!");
  if (pmap->pm_first_pte_index != -1)
    panic("pmap_release: pmap still contains ptes");
  if (pmap->pm_count != 0)
    panic("pmap_release: pmap still referenced");
  
  /* return the vsid to the vsid table */
  vsid_table->vsids[vsid_table_index(pmap->vsid_base)] |= vsid_table_mask(pmap->vsid_base);

  /* Q.E.D. */
}



/* (from alpha code)
 *	Retire the given physical map from service.
 *	Should only be called if the map contains
 *	no valid mappings.
 */
void
pmap_destroy(pmap_t pmap)
{
  int count;

  If (pmap == NULL)
    return;
  simple_lock(&pmap->pm_lock);
  count = (--pmap->pm_count);
  simple_unlock(&pmap->pm_lock);
  if (count == 0) {
    pmap_release(pmap);
    free((caddr_t)pmap, M_VMPMAP);
  }
}



/* Half the dirty work.

   Insert or update page at PA in PMAP at VA.  Assume, if page outside
   of our page table it is a physical device and hence guard etc its
   entry */

void
pmap_enter(pmap_t pmap,
	   vm_offset_t va,
	   vm_offset_t pa, /* assumed to be true physical addr */
	   vm_prot_t prot,
	   boolean_t wired)
{
  unsigned pte_index;
  int need_tlb_rebuild = 0;
  pte_t *pte;
  pte_annex_t *pte_annex;
  pte_t new_pte;

  /* find/allocate a pte in the hash table.  This may result in a htab
     entry being stolen */
  pte_index = allocate_htab_pte(pmap->vsid_base,
				va, pa);
  pte_annex = &htab_annex.pte[pte_index];
  pte = &htab.pte[pte_index];

  /* an update ? */
  if (pte_valid_bit(pte)) {
    if (pte_annex->wired != wired) {
      htab_annex.pte[pte_index].wired = wired;
      need_tlb_rebuild = 1; /* wimg bits */
    }
    if (pte_page_protection_bits(pte) != prot2pp[prot]) {
      need_tlb_rebuild = 1;
    }
  }
  else {
    need_tlb_rebuild = 1;
    /* insert this newly allocated pte into the pmap pte list */
    if (pmap->first_pte_index != -1) {
      htab_annex[pmap->first_pte_index].pmap_pte_last = pte_index;
      htab_annex[pmap->first_pte_index].is_first_pmap_pte = 0;
    }
    pte_annex->pmap_pte_next = pmap->first_pte_index;
    pte_annex->is_first_pmap_pte = 1;
    pte_annex->pmap_pte_last = (int)&pmap->first_pte_index;
    pmap->first_pte_index = pte_index;
    /* insert this newly allocated pte into the page pte list */
    pte_annex->page_pte_next = page[something];
    page[something] = pte_index;
  }

  /* construct the pte proper */
  new_pte[0] = (BIT32(0)
		| vsid
		| pte_annex->h
		| page2api(page)
		);
  new_pte[1] = ((rpn << 12)
		| (wimg << 3)
		| (pp)
		);

  /* finally, insert the pte into the page list */
  validate_pte_entry(something-goes-here);

}


/* remove the pte from both the pmap and page tables */
static void
unlink_pte(int pte_index)
{
  int page_index = something;
  int this_page_index;
  int last_page_index;
  int i;
  pte_annex_t *pte_annex = &htab_annex.pte[pte_index];

  /* remove from pmap */
  if (pte_annex->is_first_pmap_pte) {
    int *pmap_pte_index = (int*)pte_annex->last_pmap_pte;
    if (pte_annex->next_pmap_pte == -1) {
      *pmap_pte_index = -1;
    }
    else {
      *pmap_pte_index = pte_annex->next_pmap_pte;
      htab_annex[pte_annex->next_pmap_pte].last_pmap_pte = (int)pmap_pte_index;
      htab_annex[pte_annex->next_pmap_pte].is_first_pmap_pte = 1;
    }
  }
  else {
    htab_annex.pte[pte_annex->last_pmap_pte] = pte_annex->next_pmap_pte;
    htab_annex.pte[pte_annex->next_pmap_pte] = pte_annex->last_pmap_pte;
  }

  /* remove from page */
  last_page_index = -1;
  for (this_page_index = page[page_index];
       this_page_index != pte_index && this_page_index != -1;
       this_page_index = htab_annex.pte[this_page_index].page_pte_next) {
    last_page_index = this_page_index;
  }
  if (this_page_index == -1)
    panic("page linked list stuffed");
  if (last_page_index == -1) {
    page[page_index] = pte_annex->page_pte_next;
  }
  else {
    htab_annex.pte[last_page_index].page_pte_next = pte_annex->page_pte_next;
  }
}


void
pmap_remove(pmap_t pmap,
	    vm_offset_t lo_va,
	    vm_offset_t hi_va)
{
  int this_pte_index;
  int next_pte_index;
  int need_to_flush;
  
  this_pte_index = pmap->first_pte_index;
  while (pte_index != -1) {
    unsigned va = pte_va(htab.pte[pte_index]);
    int next_pte_index = htab_annex.pte[last_pte_index].pmap_pte_next;
    if (va >= lo_va && va < hi_va) {
      need_to_flush = 1;
      unlink_pte(pte_index);
    }
    this_pte_index = next_pte_index;
  }
  if (need_to_flush)
    something_to_flush_entire_tlb_goes_here();
}


/* Get summary status information about a page that is possibly in the
   page table */
 
boolean_t
pmap_is_referenced(vm_offset_t pa)
{
  int pte_index;
  for (pte_index = page[something(pa)];
       pte_index != -1;
       pte_index = htab_annex.pte[pte_index].next_page_pte) {
    if (pte_rwm_bits(htab.pte[pte_index]) & referenced)
      return TRUE;
  }
  return FALSE;
}


boolean_t
pmap_is_modified(vm_offset_t pa)
{
  int pte_index;
  for (pte_index = page[something(pa)];
       pte_index != -1;
       pte_index = htab_annex.pte[pte_index].next_page_pte) {
    if (pte_rwm_bits(htab.pte[pte_index]) & modified)
      return TRUE;
  }
  return FALSE;
}
