/* This test checks out the behavour of the simulators endian
   switching code */

#include "../lib/oea_pal.h"

/* Ref: PowerPC(tm) Endian Switch Code.  Gary Y Tsao et.al. */

#define hid0 1008

.globl catch
catch:

.globl main
main:


/* flush d cache -- from PPC NT code. good on LRU */

	addi 20,0, 0x400	# number cache sectors
	mtctr 20		# move to count reg.
	addi 19, 0, -64		# start address -
				# sizeof line

lcache:
	lbzu 18, 64(19)		# touch
	bdnz lcache
fcache:
	dcbf 0, 19		# flush each sector
	dcbf 18, 19
	addic. 19, 19, -64
	bge fcache

/* Invalidate I-cache */
	mfspr 2, hid0		# read HID0 register
	ori 9, 2, 0x0800	# set bit 20 - icfi
	rlwinm 9, 9, 0, 17, 15	# reset bit 16 - ICE
	rlwinm 2, 2, 0, 21, 19	# reset bit 20 - ICFI
	ori 2, 2, 0x8000	# set bit 16 - ICE
	isync
	mtspr hid0, 9		# invalidate i-cache
	mtspr hid0, 2		# enable i-cache


/* set MSR ILE (bit15). Since this bit is not copied
   from SRR1.  Here we set it manually */

	mfmsr 9			# get current msr register
	xoris 9, 9, 0x0001	# flip msr(15)
	mtmsr 9
	rlwinm 9, 9, 0, 16, 14	# reset bit 15, we should not
				# load SRR1 with this bit set
	xori 9, 9, 0x0001	# flip SRR1(31) - LE bit
	mtsrr1 9		# move r9 to SRR1 register

/* Set up r5(addr) r6(value) for access to Ref Implementation
   Endian Port (different for other bridges)
 	addi 6, 0, 0x92		# Load r6 endian
 	oris 6, 6, 0x8000	# port 92 address
 	lbz 5, 0(6)		# Read port 92
 	ori 5, 5, 0x02		# Set r5 with LE
 	addi 6, 0, 0x95		# Load r6 with munged
 	oris 6, 6, 0x8000	# port 92 address */


/* Load SRR0 with branch address */

	b al			# Link reg = addr of x
.align 8
al:	bl x
x:
	mflr 2			# move from LR register to r2
	addi 2, 2, y-x		# point to insn after rfi
	mtsrr0 2		# stre address into SRR0
	ori 0, 0, 0		# put the rfi at the end of a line
	rfi			# cpu endian changing
y:

/* Initiate system endian switching
	stb 5, 0(6) */


/* Following palindromic instructions serve two purposes:
   Instructions in I cache will be executed correctly
   Wait for system endian changing to become effective
   24 is enough for 66 MHz.  But more is required for higher
   speed processor. */

	addi 0, 1, 0x138	# no-op  1
	addi 0, 1, 0x138	# no-op  2
	addi 0, 1, 0x138	# no-op  3
	addi 0, 1, 0x138	# no-op  4
	addi 0, 1, 0x138	# no-op  5
	addi 0, 1, 0x138	# no-op  6
	addi 0, 1, 0x138	# no-op  7
	addi 0, 1, 0x138	# no-op  8
	addi 0, 1, 0x138	# no-op  9
	addi 0, 1, 0x138	# no-op 10
	# ....

	
/* Halt the processor - writing 0 in just the right address

   Here we're in LE mode.  On PSIM, since it is simply XOR'ing
   addresses, can create LE assembler in a BE file by just
   swapping alternative words. */


	li 6, 0			# 2
	li 6, 0			# 1

	ori 6, 6, (((OEA_DEV + PAL_RESET) & 0xffff) ^ 0x7)  # 4
	addis 6, 6, ((OEA_DEV + PAL_RESET) >> 16)	# 3

	li 5, 0			# 6
	li 5, 1			# 5 - xor broken then this one used

	stb 5, 0(6)		# 8
	stb 5, 0(6)		# 7
