#include "../lib/oea_pal.h"

	/* Simple test rig */

#define RESET_STACK \
	addis 1, 0, interrupt_stack@H ; \
	ori 1, 1, interrupt_stack@L ; \
	addi 1, 1, 4000
	



	.globl _start
	.globl reset_interrupt
	.align 8
reset_interrupt:
	.globl _start
_start:
	mfmsr 0
	# set the recoverable_interrupt bit (62{30})
	ori 0, 0, 0x2
	# clear the interrupt prefix bit (57{25})
	addi 10, 0, 0x40
	andc 0, 0, 10
	# clear the floating point enable (0x0001000057{25})
	addis 10, 0, 0x1
	andc 0, 0, 10
	# put the new MSR back
	mtmsr 0		# no sync (p486)

	# set the global offset table pointer
	addis 2, 0, _GLOBAL_OFFSET_TABLE_@H
	ori 2, 2, _GLOBAL_OFFSET_TABLE_@L

	# claim exclusive CPU rights
	addis 3, 0, ((OEA_DEV + PAL_CPU_NR) >> 16)
	ori 3, 3, ((OEA_DEV + PAL_CPU_NR) & 0xffff)
	lwz 3, 0(3) /* who am i? */
	cmpwi 3, 0 /* if zero continue else idle */
	beq cpu_zero
	b trap_smpee
cpu_zero:

	bl main
	.extern exit
	bl exit

	.globl __main
__main:
	.globl __eabi
__eabi:
	blr


#define TRAP(NAME) \
	.align 8 ; \
	.globl NAME##_interrupt ; \
NAME##_interrupt: ; \
	mfsrr0 3 ; \
	mfsrr1 4 ; \
	addi 5, 0, NAME##_interrupt@L ; \
	mfmsr 6 ; \
	mfdar 7 ; \
	RESET_STACK ; \
	ori 0, 6, 0x2 ; /* set recoverable interrupt */ \
	mtmsr 0; \
	bl catch

TRAP(system_error)
TRAP(machine_check)
TRAP(data_storage)
TRAP(instruction_storage)
TRAP(external)
TRAP(alignment)
TRAP(program)
TRAP(floatingpoint_unavailable)
TRAP(decrementer)
TRAP(reserved_00a00)
TRAP(reserved_00b00)
TRAP(system_call)
TRAP(trace)
TRAP(floatingpoint_assist)
TRAP(reserved_0)


	.comm interrupt_stack, 4096, 4
