/* move to special purpose register (value)
    3 = sp-register
    4 = value
    5 = table entry
    6 = return address
 */

	.globl move_to_spr
move_to_spr:
	mflr 6 /* find where we are */
	bl move_to_spr_base
move_to_spr_base:
	mflr 5
	addi 5, 5, move_to_spr_table - move_to_spr_base
	rlwinm 0, 3, 3, 19, 28 # spr_table+((spr & 0x1f) << (5+3))
	add 5, 5, 0
	mtctr 5
	mtlr 6
	bctr

#define MTSPR(i) \
	mtspr i, 4 ; blr
#define MTSPR16(i) \
	MTSPR(i+0) ; MTSPR(i+1) ; \
	MTSPR(i+2) ; MTSPR(i+3) ; \
	MTSPR(i+4) ; MTSPR(i+5) ; \
	MTSPR(i+6) ; MTSPR(i+7) ; \
	MTSPR(i+8) ; MTSPR(i+9) ; \
	MTSPR(i+10) ; MTSPR(i+11) ; \
	MTSPR(i+12) ; MTSPR(i+13) ; \
	MTSPR(i+14) ; MTSPR(i+15)

#define MTSPR256(i) \
	MTSPR16(i+0) ; MTSPR16(i+16) ; \
	MTSPR16(i+32) ; MTSPR16(i+48) ; \
	MTSPR16(i+64) ; MTSPR16(i+80) ; \
	MTSPR16(i+96) ; MTSPR16(i+112) ; \
	MTSPR16(i+128) ; MTSPR16(i+144) ; \
	MTSPR16(i+160) ; MTSPR16(i+176) ; \
	MTSPR16(i+192) ; MTSPR16(i+208) ; \
	MTSPR16(i+224) ; MTSPR16(i+240)
	

move_to_spr_table:
	MTSPR256(0)
	MTSPR256(256)
	MTSPR256(512)
	MTSPR256(768)




#
# Instruction BAT registers
#
		
	.globl move_to_ibatu0
move_to_ibatu0:
	mtibatu 0, 3
	blr

	.globl move_to_ibatl0
move_to_ibatl0:
	mtibatl 0, 3
	blr

	
#
# Data BAT registers
#
	
	.globl move_to_dbatu0
move_to_dbatu0:
	mtdbatu 0, 3
	blr

	.globl move_to_dbatl0
move_to_dbatl0:
	mtdbatl 0, 3
	blr
