/*	$NetBSD$ */
/*
 * Copyright (c) 1995 Dale Rahn.
 * All rights reserved.
 *   
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *   This product includes software developed by Dale Rahn.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */  
/*
 * bug routines -- assumes that the necessary sections of memory
 * are preserved.
 */


#define _INCHR		0x00
#define _INSTAT		0x01
#define _INLN		0x02
#define _READSTR	0x03
#define _READLN		0x04
#define _OUTCHR		0x20
#define _OUTSTR		0x21
#define _OUTLN		0x22
#define _DSKRD		0x10
#define _DSKWR		0x11
#define _DSKCFIG	0x12
#define _DSKFMT		0x14
#define _DSKCTRL	0x15
#define _WRITE		0x23
#define _WRITELN	0x24
#define _DELAY		0x43
#define _RTC_RD		0x53
#define _RETURN		0x63
#define _BRD_ID		0x70

/* BUG  -  tty routines */

#define BUG_CALL(x)	\
	addi 10,0, x ;  \
	sc


#define GLOBAL(x)       \
	.globl x ;      \
	x :

/* some junk to keep gcc happy */
GLOBAL(__eabi)
	blr
GLOBAL(_start)
	bl main
	bl bug_exit


GLOBAL(bug_inchr) /*()*/
	BUG_CALL(_INCHR)
	blr

/* returns 0 if no characters ready to read */
GLOBAL(bug_instat) /*()*/
	BUG_CALL(_INSTAT)
	xori 3, 3, 0x4 /* flip the status bit then return it */
	andi. 3, 3, 0x4
	blr

GLOBAL(bug_outchr) /*(char a)*/
	BUG_CALL(_OUTCHR)
	blr

GLOBAL(bug_outstr) /*(char *pstrb, char *pstre)*/
	BUG_CALL(_OUTSTR)
	blr

GLOBAL(bug_outln) /*(char *pstrb, char *pstre)*/
	BUG_CALL(_OUTLN)
	blr


/* BUG - disk routines */

/* returns 0: success, nonzero: error */
GLOBAL(bug_diskrd) /*(bug_dskio *arg)*/
	BUG_CALL(_DSKRD)
	xori 3, 3, 0x4 /* flip the status bit then return it */
	andi. 3, 3, 0x4
	blr

/* returns 0: success, nonzero: error */
GLOBAL(bug_diskwr) /*(bug_dskio *arg)*/
	BUG_CALL(_DSKWR)
	xori 3, 3, 0x4 /* flip the status bit then return it */
	andi. 3, 3, 0x4
	blr

#ifdef NOTYET
bug_diskcfig() {}
bug_diskfmt(){}
bug_diskctrl(){}
#endif


/* BUG - timing routine */

GLOBAL(bug_delay) /*(int delay_msec)*/
	BUG_CALL(_DELAY)
	blr


/* BUG - return to bug routine */

GLOBAL(bug_exit) /*()*/
GLOBAL(bug_return) /*()*/
	BUG_CALL(_RETURN)
	/*NOTREACHED*/


/* BUG - query board routines */

/*struct bug_brdid * */ GLOBAL(bug_brdid) /*()*/
	BUG_CALL(_BRD_ID)
	blr

GLOBAL(bug_rtc_rd) /*(struct bug_time *ptime)*/
	BUG_CALL(_RTC_RD)
	blr
