/* the reset pins */

#include "opic.h"

static void
invalid(int init,
	int processor)
{
  write_string("Init output ");
  write_int(processor);
  write_string(" invalid for init register value 0x");
  write_hex(init);
  write_line();
  exit (1);
}

int
main()
{
  
  int i;
  opic_descriptor opic;
  opic_parse_args(&opic, 0);

  /* run through all the possible reset values, setting and checking
     each in turn */

  for (i = 0; i < opic.nr_inits; i++) {
    int j;
    for (j = 0; j < 2; j++) {
      int init = (1 << i);
      int processor;
      if (j == 1)
	init = (~init & ((1 << opic.nr_inits) - 1));
      opic.global->processor_init.reg = htovl(init);
      if (init != vtohl(opic.global->processor_init.reg)) {
	LINE;
	write_string("Value read != value written");
	write_line();
	exit (1);
      }
      for (processor = 0; processor < opic.nr_inits; processor++) {
	if (init & (1 << processor)) {
	  if (opic.init[processor] == 0) {
	    LINE;
	    invalid(init, processor);
	  }
	}
	else {
	  if (opic.init[processor] != 0) {
	    LINE;
	    invalid(init, processor);
	  }
	}
      }
    }
  }
  exit (0);
}
