#include "../lib/of1275.h"
#include "opic.h"

int
main()
{
  
  int i;
  int cpu;
  opic_descriptor opic;

  opic_parse_args(&opic, 0);

  /* program up interrupt source zero */
  for (i = 0; i < opic.nr_inputs; i++) {
    opic.interrupt_source_configuration[i].vector_priority.reg = 
      htovl(level_triggered | positive_polarity | ((i + 1) << 16) | (i + 1));
    opic.interrupt_source_configuration[i].destination.reg = htovl(-1);
  }


  /* enable interrupts */
  for (i = 0; i < opic.nr_outputs; i++)
    opic.per_processor[i].current_task_priority.reg = htovl(0);


  /* Stimulate the next interrupt once the previous has been ack'ed
     but not eoi'd - forces the use of the interrupt stack */

  cpu = 0;

  for (i = 0; i < opic.nr_inputs; i++) {

    int j;

    /* pend interrupt */
    opic.input[i] = htonl(1);

    /* check pending */
    for (j = 0; j < opic.nr_outputs; j++) {
      if (j == cpu) {
	if (htonl(opic.output[j]) == 0) {
	  LINE;
	  write_string("no pending interrupt ");
	  write_int(j);
	  write_line();
	  exit (1);
	}
      }
      else {
	if (htonl(opic.output[j]) != 0) {
	  LINE;
	  write_string("stray pending interrupt ");
	  write_int(j);
	  write_line();
	  exit (1);
	}
      }
    }

    /* check delivery */
    for (j = 0; j < opic.nr_outputs; j++) {
      if (j == cpu) {
	if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != i + 1) {
	  LINE;
	  write_string("bad ack for ");
	  write_int(j);
	  write_line();
	  exit (1);
	}
      }
      else {
	if (vtohl(opic.per_processor[j].interrupt_acknowledge.reg) != 255) {
	  LINE;
	  write_string("bad spurious ack for ");
	  write_int(j);
	  write_line();
	  exit (1);
	}
      }
    }

    /* check pending cleared */
    for (j = 0; j < opic.nr_outputs; j++) {
      if (j == cpu) {
	if (htonl(opic.output[j]) != 0) {
	  LINE;
	  write_string("uncleard interrupt ");
	  write_int(j);
	  write_line();
	  exit (1);
	}
      }
      else {
	if (htonl(opic.output[j]) != 0) {
	  LINE;
	  write_string("stray uncleard interrupt ");
	  write_int(j);
	  write_line();
	  exit (1);
	}
      }
    }

    cpu = (cpu + 1) % opic.nr_outputs;

  }

  /* unwind the interrupt stacks */
  for (i = opic.nr_inputs - 1; i >= 0; i--) {

    if (cpu == 0)
      cpu = opic.nr_outputs - 1;
    else
      cpu -= 1;

    /* clear pending */
    opic.input[i] = htonl(0);

    /* ack the just cleared */
    opic.per_processor[cpu].end_of_interrupt.reg = 0;

    /* check nothing pending */
    if (vtohl(opic.per_processor[cpu].interrupt_acknowledge.reg) != 255) {
      LINE;
      write_string("interrupt still pending");
      write_line();
      exit (1);
    }

  }

  exit (0);
}
