#include "eeprom.h"

void
parse_eeprom_args(eeprom_args *eeprom)
{
  /* figure out the devices address - assume everything simple */
  char bootargs[128];
  int i;
  of_find_string_property("/chosen", "bootargs", bootargs, sizeof(bootargs));
  write_string("args: ");
  write_string(bootargs);
  write_line();

  /* get the path */
  for (i = 0;
       bootargs[i] != '\0' && bootargs[i] != ' ' && bootargs[i] != '\t';
       i++) {
    eeprom->path[i] = bootargs[i];
  }
  eeprom->path[i] = '\0';

  /* get the memory address */
  eeprom->memory = (void*)strtoul(&bootargs[i], 0, 0);

  /* the config options */
  eeprom->nr_sectors = of_find_integer_property(eeprom->path, "nr-sectors");
  eeprom->sector_size = of_find_integer_property(eeprom->path, "sector-size");
  eeprom->byte_write_delay = of_find_integer_property(eeprom->path, "byte-write-delay");
  eeprom->sector_start_delay = of_find_integer_property(eeprom->path, "sector-start-delay");
  eeprom->erase_delay = of_find_integer_property(eeprom->path, "erase-delay");
  eeprom->man_code = of_find_integer_property(eeprom->path, "manufacture-code");
  eeprom->dev_code = of_find_integer_property(eeprom->path, "device-code");

  write_string(eeprom->path);
  write_string(": address 0x");
  write_hex(eeprom->memory);
  write_string(", nr-sectors ");
  write_int(eeprom->nr_sectors);
  write_string(", sector_size 0x");
  write_hex(eeprom->sector_size);
  write_line();
}

void
erase_eeprom(eeprom_args *eeprom)
{
  eeprom->memory[0x5555] = 0xaa;
  eeprom->memory[0x2aaa] = 0x55;
  eeprom->memory[0x5555] = 0x80;
  eeprom->memory[0x5555] = 0xaa;
  eeprom->memory[0x2aaa] = 0x55;
  eeprom->memory[0x5555] = 0x10;
}

erase_sector_status
erase_sector(eeprom_args *eeprom,
	     int check,
	     unsigned sector)
{
  if (check >= 0 && (eeprom->memory[check] & 0x8) != 0x00) {
    write_string("Erase sector window already closed");
    write_line();
    return erase_sector_window_already_closed;
  }
  eeprom->memory[0x5555] = 0xaa;
  eeprom->memory[0x2aaa] = 0x55;
  eeprom->memory[0x5555] = 0x80;
  eeprom->memory[0x5555] = 0xaa;
  eeprom->memory[0x2aaa] = 0x55;
  eeprom->memory[sector] = 0x30;
  if ((eeprom->memory[sector] & 0x8) != 0x00) {
    return erase_sector_window_closed;
  }
  return erase_sector_ok;
}


void
program_byte(eeprom_args *eeprom,
	     unsigned address,
	     unsigned char byte)
{
  eeprom->memory[0x5555] = 0xaa;
  eeprom->memory[0x2aaa] = 0x55;
  eeprom->memory[0x5555] = 0xa0;
  eeprom->memory[address] = byte;
}

