/* erase the entire eeprom */

#include "eeprom.h"


int
main()
{
  int i;
  eeprom_args eeprom;

  parse_eeprom_args(&eeprom);

  /* get the eeprom into autoselect mode */
  eeprom.memory[0x5555] = 0xaa;
  eeprom.memory[0x2aaa] = 0x55;
  eeprom.memory[0x5555] = 0x90;

  /* verify our to codes */
  if (eeprom.memory[0] != eeprom.man_code
      || eeprom.memory[0] == 0) {
    write_string("Invalid man-code");
    write_line();
    exit(1);
  }
  if (eeprom.memory[1] != eeprom.dev_code
      || eeprom.memory[1] == 0) {
    write_string("Invalid dev-code");
    write_line();
    exit(1);
  }

  /* reset it */
  eeprom.memory[0] = 0xf0;

  /* verify back to zero */
  if (eeprom.memory[0] != 0) {
    write_string("Invalid !man-code");
    write_line();
    exit(1);
  }
  if (eeprom.memory[1] != 0) {
    write_string("Invalid !dev-code");
    write_line();
    exit(1);
  }

  exit (0);
}
