/*
 * tools/lib/lvm_check_partitioned_dev.c
 *
 * Copyright (C) 1999 - 2001 Heinz Mauelshagen, Sistina Software
 *
 * March,July,August 1999
 * January,April 2000
 * February 2001
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    05/07/1999 - added 2.3.x new IDE majors
 *    20/08/1999 - added DAC960 majors
 *    31/01/2000 - use debug_enter()/debug_leave()
 *    26/04/2000 - added DASD major support
 *    07/02/2001 - added COMPAQ_CISS & SMART2 major support
 *
 */

#include <liblvm.h>

int lvm_partition_count ( dev_t);

dev_t valid_majors[] = {
#ifndef SCSI_DISK0_MAJOR
   SCSI_DISK_MAJOR,
#else
   SCSI_DISK0_MAJOR,
   SCSI_DISK1_MAJOR,
   SCSI_DISK2_MAJOR,
   SCSI_DISK3_MAJOR,
   SCSI_DISK4_MAJOR,
   SCSI_DISK5_MAJOR,
   SCSI_DISK6_MAJOR,
   SCSI_DISK7_MAJOR,
#endif
   IDE0_MAJOR,
   IDE1_MAJOR,
   IDE2_MAJOR,
   IDE3_MAJOR,
#ifdef IDE4_MAJOR
   IDE4_MAJOR,
#endif
#ifdef IDE5_MAJOR
   IDE5_MAJOR,
#endif
#ifdef IDE6_MAJOR
   IDE6_MAJOR,
#endif
#ifdef IDE7_MAJOR
   IDE7_MAJOR,
#endif
#ifdef IDE7_MAJOR
   IDE8_MAJOR,
#endif
#ifdef IDE7_MAJOR
   IDE9_MAJOR,
#endif
#ifdef	DAC960_MAJOR
   DAC960_MAJOR,
   DAC960_MAJOR+1,
   DAC960_MAJOR+2,
   DAC960_MAJOR+3,
   DAC960_MAJOR+4,
   DAC960_MAJOR+5,
   DAC960_MAJOR+6,
   DAC960_MAJOR+7,
#endif
#ifdef	COMPAQ_SMART2_MAJOR
   COMPAQ_SMART2_MAJOR,
   COMPAQ_SMART2_MAJOR1,
   COMPAQ_SMART2_MAJOR2,
   COMPAQ_SMART2_MAJOR3,
   COMPAQ_SMART2_MAJOR4,
   COMPAQ_SMART2_MAJOR5,
   COMPAQ_SMART2_MAJOR6,
   COMPAQ_SMART2_MAJOR7,
#endif
#ifdef	COMPAQ_CISS_MAJOR
   COMPAQ_CISS_MAJOR,
   COMPAQ_CISS_MAJOR1,
   COMPAQ_CISS_MAJOR2,
   COMPAQ_CISS_MAJOR3,
   COMPAQ_CISS_MAJOR4,
   COMPAQ_CISS_MAJOR5,
   COMPAQ_CISS_MAJOR6,
   COMPAQ_CISS_MAJOR7,
#endif
#ifdef	DASD_MAJOR
   DASD_MAJOR,
#endif
#ifdef UBD_MAJOR
   UBD_MAJOR,
#endif
   -1
};

int lvm_check_partitioned_dev ( dev_t st_rdev) {
   int ret = FALSE;

   debug_enter ( "lvm_check_partitioned_dev -- CALLED\n");

   if ( st_rdev == 0) ret = -LVM_EPARAM;
   else {
      const int major = MAJOR ( st_rdev);
      dev_t *dev;

      for ( dev = valid_majors; *dev != -1; dev++) {
         if ( major == *dev) {
            ret = TRUE;
            break;
         }
      }
   }

   debug_leave ( "lvm_check_partitioned_dev -- LEAVING with ret: %s\n",
                 ret ? "TRUE" : "FALSE");
   return ret;
}


int lvm_check_whole_disk_dev ( dev_t st_rdev) {
   int ret = UNDEF;

   debug_enter ( "lvm_check_whole_disk_dev -- CALLED\n");

   if ( st_rdev == 0) {
      ret = -LVM_EPARAM;
   } else if ( ( MINOR ( st_rdev) % lvm_partition_count ( st_rdev)) == 0) {
      ret = TRUE;
   }

   debug_leave ( "lvm_check_whole_disk_dev -- LEAVING with ret: %s\n",
                 ret ? "TRUE" : "FALSE");
   return ret;
}


/* st_rdev must be valid if you are not checking the return value */
int lvm_partition_count ( dev_t st_rdev) {
   int ret = 16;

   debug_enter ( "lvm_partition_count -- CALLED for 0x%x\n", st_rdev);

   if ( st_rdev == 0) ret = -LVM_EPARAM;
#ifdef DASD_MAJOR
   else if ( MAJOR ( st_rdev) == DASD_MAJOR)
      ret = 4;
#endif
#ifdef DAC960_MAJOR
   else if ( MAJOR ( st_rdev) >= DAC960_MAJOR &&
             MAJOR ( st_rdev) <= DAC960_MAJOR + 7) ret = 8;
#endif

   debug_leave ( "lvm_partition_count -- LEAVING with ret: %d\n", ret);
   return ret;
}


int lvm_check_extended_partition ( dev_t st_rdev) {
   int ret = FALSE;

   debug_enter ( "lvm_check_extended_partition -- CALLED\n");

   if ( st_rdev == 0) ret = -LVM_EPARAM;
   else if ( MINOR ( st_rdev) % lvm_partition_count ( st_rdev) > 4) ret = TRUE;

   debug_leave ( "lvm_check_extended_partition -- LEAVING with ret: %d\n", ret);
   return ret;
}
