/*
 * tools/lib/pv_setup_for_create.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * March 1997
 * January 1999
 * January,March,September 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    13/01/1999 - added memset pv_name and vg_name
 *               - added zeroing of rest of pv_name
 *    08/02/2000 - use debug_enter()/debug_leave()
 *    17/03/2000 - changed namelist to uuidlist
 *    24/04/2000 - used lvm_create_uuid() to initialize physical volume UUID
 *    28/09/2000 - fixed bug if called with vg->pv->pv_name as dev_name
 *
 */

#include <liblvm.h>


int pv_setup_for_create ( char *dev_name, pv_t *pv, uint size) {
   int i = 0;
   int ret = 0;

#ifdef DEBUG
   debug_enter ( "pv_setup_for_create -- CALLED\n");
#endif

   if ( dev_name == NULL ||
        pv_check_name ( dev_name) < 0 ||
        pv == NULL ||
        size == 0) ret = -LVM_EPARAM;
   else {
      strncpy ( pv->id, LVM_ID, sizeof ( pv->id));
      pv->version = LVM_STRUCT_VERSION;
      pv->pv_on_disk.base = LVM_PV_DISK_BASE;
      pv->pv_on_disk.size = LVM_PV_DISK_SIZE;
      pv->vg_on_disk.base = 0;
      pv->vg_on_disk.size = 0;
      pv->pv_uuidlist_on_disk.base = 0;
      pv->pv_uuidlist_on_disk.size = 0;
      pv->lv_on_disk.base = 0;
      pv->lv_on_disk.size = 0;
      pv->pe_on_disk.base = 0;
      pv->pe_on_disk.size = 0;
      strncpy ( pv->pv_name, dev_name, sizeof ( pv->pv_name) - 1);
      for ( i =  strlen ( dev_name) + 1; i < sizeof ( pv->pv_name); i++)
         pv->pv_name[i] = 0;
      memset ( pv->vg_name, 0, sizeof ( pv->vg_name));
      system_id_set ( pv->system_id);
      pv->pv_dev = pv_create_kdev_t ( pv->pv_name);
      pv->pv_number = 0;
      pv->pv_status = 0; /* bitfield */
      pv->pv_allocatable = PV_ALLOCATABLE; /* bitfield */
      pv->pv_size = size;
      pv->lv_cur = 0;
      pv->pe_size = 0;
      pv->pe_total = 0;
      pv->pe_allocated = 0;
      pv->pe_stale = 0;
      pv->pe = NULL;
      pv->inode = NULL;
      memset ( pv->pv_uuid, 0, sizeof ( pv->pv_uuid));
      strncpy ( pv->pv_uuid,
                lvm_create_uuid ( UUID_LEN),
                sizeof ( pv->pv_uuid)-1);
   }

#ifdef DEBUG
   debug_leave ( "pv_setup_for_create -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
