/*
 * tools/lib/pv_reserve_release_pe.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * March 1997
 * July  1998
 * January,July,September 1999
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    07/07/1998 - added read/write statistic init
 *    21/01/1999 - fixed contiguous logical volume extension bug
 *    05/07/1999 - fixed striped logical volume shrink bug
 *    29/10/1999 - fixed possible free() bug
 *    08/02/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>

int pv_reserve_pe ( pv_t *pv, disk_pe_t *lv_pe, uint *pe,
                    pe_t *pe_p, uint allocation, int new) {
   int np = 0;
   int p = 0;
   int ret = 0;

#ifdef DEBUG
   debug_enter ( "pv_reserve_pe -- CALLED: pv->pv_dev: %02d:%02d  lv_num: %d"
                 "  le_num: %d  pv->pe_total: %lu\n",
                 MAJOR(pv->pv_dev),
                 MINOR(pv->pv_dev),
                 lv_pe->lv_num,
                 lv_pe->le_num,
                 pv->pe_total);
#endif

   if ( pv == NULL || lv_pe == NULL || lv_pe->lv_num > MAX_LV ||
        pe == NULL || *pe == 0 || pe_p == NULL ||
        ( allocation != 0 && allocation != LV_CONTIGUOUS) ||
        ( new != TRUE && new != FALSE)) {
      ret = -LVM_EPARAM;
      goto pv_reserve_pe_end;
   }

   for ( p = 0; p < pv->pe_total && np < *pe; p++) {
      if ( pv->pe[p].lv_num == 0) {
#ifdef DEBUG
      debug ( "pv_reserve_pe -- empty PE %d\n", p);
#endif
         if ( lv_check_on_pv ( pv, lv_pe->lv_num) == TRUE) {
            if ( new == FALSE && ( allocation & LV_CONTIGUOUS) &&
                 pv->pe[p-1].lv_num != lv_pe->lv_num) {
               ret = -LVM_ESIZE;
               goto pv_reserve_pe_end;
            }
         }
         pv->pe[p].lv_num = lv_pe->lv_num;
         pv->pe[p].le_num = lv_pe->le_num;
         lv_pe->le_num++;
         pv->pe_allocated++;
         pe_p->dev = pv->pv_dev;
         pe_p->pe = LVM_PE_DISK_OFFSET( p, pv);
         pe_p->reads = pe_p->writes = 0;
         pe_p++;
         np++;
      }
   }
   *pe -= np;

pv_reserve_pe_end:
#ifdef DEBUG
   debug_leave ( "pv_reserve_pe -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}


int pv_release_pe ( vg_t *vg, disk_pe_t *lv_pe, uint *pe, uint stripes) {
   int l = 0;
   int pv_num = 0;
   int ret = 0;
   uint dest = 0;
   uint i = 0;
   uint j = 0;
   uint length = 0;
   uint np = 0;
   uint offset = 0;
   uint pe_index = 0;
   uint source = 0;
   uint p = 0;
   pe_t *lv_current_pe_sav = NULL;

#ifdef DEBUG
   debug_enter ( "pv_release_pe -- CALLED\n");
#endif

   if ( vg == NULL || lv_pe == NULL || lv_pe->lv_num > vg->lv_max ||
        pe == NULL || *pe == 0) {
      ret = -LVM_EPARAM;
      goto pv_release_pe_end;
   }

   l = lv_pe->lv_num - 1;
   if ( vg->lv[l]->lv_allocated_le % stripes != 0) {
      ret = -LVM_ESIZE;
      goto pv_release_pe_end;
   }
   p = vg->lv[l]->lv_allocated_le - 1;
   np = 0;

   /* linear mode */
   if ( stripes < 2) {
      while ( p >= 0 && np < *pe) {
         for ( pv_num = 0; pv_num < vg->pv_cur; pv_num++) {
            if ( vg->pv[pv_num]->pv_dev == vg->lv[l]->lv_current_pe[p].dev)
               break;
         }
         if ( pv_num == vg->pv_cur) {
            ret = -LVM_EPV_RELEASE_PE_NO_PV;
            goto pv_release_pe_end;
         }
         pe_index = ( vg->lv[l]->lv_current_pe[p].pe - 
                      LVM_DISK_SIZE ( vg->pv[pv_num]) /
                      SECTOR_SIZE) /
                      vg->pe_size;
#ifdef DEBUG
         debug ( "pv_release_pe -- pv_name: %s  pe: %lu  sector: %lu\n",
                  vg->pv[pv_num]->pv_name,
                  pe_index,
                  vg->lv[l]->lv_current_pe[p].pe);
#endif
         vg->pv[pv_num]->pe[pe_index].lv_num = \
         vg->pv[pv_num]->pe[pe_index].le_num = 0;
         vg->pv[pv_num]->pe_allocated--;
         vg->lv[l]->lv_current_le--;
         vg->lv[l]->lv_allocated_le--;
         np++;
         if ( lv_check_on_pv ( vg->pv[pv_num], lv_pe->lv_num) != TRUE)
            vg->pv[pv_num]->lv_cur--;
         p--;
      }

   /* striped mode */
   } else {
      while ( p >= 0 && np < *pe) {
         offset = vg->lv[l]->lv_allocated_le / stripes;
         for ( i = 0; i < *pe / stripes; i++) {
            for ( j = 1; j <= stripes; j++) {
               p = j * offset - 1 - i;
               for ( pv_num = 0; pv_num < vg->pv_cur; pv_num++) {
                  if ( vg->pv[pv_num]->pv_dev ==
                          vg->lv[l]->lv_current_pe[p].dev)
                     break;
               }
               pe_index = ( vg->lv[l]->lv_current_pe[p].pe - 
                            LVM_PE_DISK_OFFSET ( 0, vg->pv[pv_num])) /
                            vg->pe_size;
               vg->pv[pv_num]->pe[pe_index].lv_num = \
               vg->pv[pv_num]->pe[pe_index].le_num = 0;
               vg->pv[pv_num]->pe_allocated--;
               vg->lv[l]->lv_current_le--;
               vg->lv[l]->lv_allocated_le--;
               np++;
               if ( lv_check_on_pv ( vg->pv[pv_num], lv_pe->lv_num) != TRUE)
                  vg->pv[pv_num]->lv_cur--;
               p--;
            }
         }
         length = offset - *pe / stripes;
         for ( i = 1; i < stripes; i++) {
            source = i * offset;
            dest = source - i * ( *pe / stripes);
            for ( j = 0; j < length; j++) {
               memcpy ( &vg->lv[l]->lv_current_pe[dest+j],
                        &vg->lv[l]->lv_current_pe[source+j],
                        sizeof ( vg->lv[l]->lv_current_pe[source+j]));
               pv_num = pv_get_index_by_kdev_t (
                           vg,
                           vg->lv[l]->lv_current_pe[dest+j].dev
                        );
               vg->pv[pv_num]->pe[(vg->lv[l]->lv_current_pe[dest+j].pe-LVM_PE_DISK_OFFSET( 0, vg->pv[pv_num]))/vg->pe_size].le_num = dest+j;
            }
         }
         lv_current_pe_sav = vg->lv[l]->lv_current_pe;
         if ( ( vg->lv[l]->lv_current_pe =
                realloc ( vg->lv[l]->lv_current_pe,
                          stripes * length *
                          sizeof ( pe_t))) == NULL) {
            free ( lv_current_pe_sav);
            fprintf ( stderr, "realloc error in %s [line %d]\n",
                              __FILE__, __LINE__);
            ret = -LVM_EPV_RELEASE_PE_REALLOC;
            goto pv_release_pe_end;
         } else lv_current_pe_sav = NULL;
      }
   }

   *pe -= np;

pv_release_pe_end:
#ifdef DEBUG
   debug_leave ( "pv_release_pe -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
} /* pv_release_pe() */
