/*
 * tools/lib/pe_copy.c
 *
 * Copyright (C)  1998  Heinz Mauelshagen, Germany
 *
 * August 1998
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    31/01/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>


disk_pe_t *pe_copy_from_disk ( disk_pe_t *pe_file, int count) {
   int i = 0;
   disk_pe_t *pe_tmp = NULL;

#ifdef DEBUG
   debug_enter ( "pe_copy_from_disk -- CALLED\n");
#endif
   if ( pe_file != NULL && count > 0 &&
        ( pe_tmp = malloc ( sizeof ( disk_pe_t) * count)) != NULL) {
      for ( i = 0; i < count; i++) {
         pe_tmp[i].lv_num = LVM_TO_CORE16 ( pe_file[i].lv_num);
         pe_tmp[i].le_num = LVM_TO_CORE16 ( pe_file[i].le_num);
      }
   }

#ifdef DEBUG
   debug_leave ( "pe_copy_from_disk -- LEAVING\n");
#endif
   return pe_tmp;
}


disk_pe_t *pe_copy_to_disk ( disk_pe_t *pe_core, int count) {
   int i = 0;
   disk_pe_t *pe_tmp = NULL;

#ifdef DEBUG
   debug_enter ( "pe_copy_to_disk -- CALLED\n");
#endif
   if ( pe_core != NULL && count > 0 &&
        ( pe_tmp = malloc ( sizeof ( disk_pe_t) * count)) != NULL) {
      for ( i = 0; i < count; i++) {
         LVM_TO_DISK16 ( pe_tmp[i].lv_num, pe_core[i].lv_num);
         LVM_TO_DISK16 ( pe_tmp[i].le_num, pe_core[i].le_num);
      }
   }

#ifdef DEBUG
   debug_leave ( "pe_copy_to_disk -- LEAVING\n");
#endif
   return pe_tmp;
}
