/*
 * tools/lib/vg_status_get_count.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Germany
 *
 * March,November 1997
 * January 1999
 * January 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    08/02/2000 - use debug_enter()/debug_leave()
 *
 */
  
#include <liblvm.h>


int vg_status_get_count ( void) {
   int count = 0;
   int lvm = -1;
   int ret = 0;

#ifdef DEBUG
   debug_enter ( "vg_status_get_count -- CALLED\n");
#endif

   if ( ( lvm = open ( LVM_DEV, O_RDONLY)) == -1) {
      ret = -LVM_EVG_STATUS_GET_COUNT_OPEN;
   } else {
      ret = ioctl ( lvm, VG_STATUS_GET_COUNT, &count);
      close ( lvm);
   }
   if ( ret == 0) ret = count;

#ifdef DEBUG
   debug_leave ( "vg_status_get_count -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
