/*
 * tools/lib/lvm_check_number.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * June 1998
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>

#define MAX_N	32

int lvm_check_number ( char *number_str, int unit) {
   int ret = 0;
   int mul = 1;
   char *ptr = NULL;
   char n_buff[MAX_N];

#ifdef DEBUG
   debug ( "lvm_check_number -- CALLED with \"%s\"\n", number_str);
#endif

   if ( number_str == NULL || strlen ( number_str) > MAX_N-1 ||
        ( unit != TRUE && unit != FALSE)) {
      ret = -LVM_EPARAM;
      goto lvm_check_number_end;
   }

   strcpy ( n_buff, number_str);
   ptr = n_buff;

   for ( ; *ptr != 0; ptr++) {
      if ( unit == TRUE && ptr[1] == 0 &&
           ( *ptr == 'k' ||
             *ptr == 'K' ||
             *ptr == 'm' ||
             *ptr == 'M' ||
             *ptr == 'g' ||
             *ptr == 'G' ||
             *ptr == 't' ||
             *ptr == 'T')) {
         if ( *ptr == 'm' || *ptr == 'M') {
            mul = 1024;
         } else if ( *ptr == 'g' || *ptr == 'G') {
            mul = 1024*1024;
         } else if ( *ptr == 't' || *ptr == 'T') {
            mul = 1024*1024*1024;
         }
         *ptr = 0;
         break;
      } else if ( ! isdigit ( *ptr)) {
         ret = -1;
         break;
      }
   }
   if ( *ptr == 0) ret = atoi ( n_buff) * mul;

lvm_check_number_end:
#ifdef DEBUG
   debug ( "lvm_check_number -- LEAVING with ret: %d\n", ret);
#endif

   return ret;
}
