/*
 * tools/lib/pv_status.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March,November 1997
 * May 1998
 * January
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    11/18/1997 - enhanced disk loop (see disk_type)
 *    05/09/1998 - enxtended pv_status_all_pv_of_vg () to search /dev/dsk too
 *                 for future use
 *    05/03/1998 - enhanced disk loop once more (see lvm_dir_cache()) and
 *                 avoided /dev/dsk in here
 *    01/26/1999 - made volume group directory prefix a preprocessor option
 *
 */

#include <liblvm.h>

int pv_status ( char *vg_name, char *pv_name, pv_t **pv) {
   int group = -1;
   int ret = 0;
   char group_file[NAME_LEN];
   static pv_t pv_this;
   pv_status_req_t req;

#ifdef DEBUG
   debug ( "pv_status -- CALLED\n");
#endif

   if ( vg_name == NULL ||
        pv_name == NULL ||
        vg_check_name ( vg_name) < 0 ||
        pv_check_name ( pv_name) < 0 ||
        pv == NULL) return -LVM_EPARAM;

   *pv = NULL;

   sprintf ( group_file, LVM_DIR_PREFIX "%s/group%c", vg_name, 0);
   strcpy ( req.pv_name, pv_name);
   req.pv = &pv_this;
   if ( ( group = open ( group_file, O_RDONLY)) == -1)
      ret = -LVM_EPV_STATUS_OPEN;
   else ret = ioctl ( group, PV_STATUS, &req);

   if ( ret == -1) ret = -errno;
   else            *pv = &pv_this;

   if ( group != -1) close ( group);

#ifdef DEBUG
   debug ( "pv_status -- LEAVING\n");
#endif

   return ret;
}


int pv_status_all_pv_of_vg ( char *vg_name, pv_t ***pv, int reread) {
   int cache_size = 0;
   int n = 0;
   int np = 0;
   int p = 0;
   int ret = 0;
   static int first = 0;
   static char vg_name_sav[NAME_LEN] = { 0, };
   char *pv_name = NULL;
   pv_t **pv_this_sav = NULL;
   static pv_t **pv_this = NULL;
   pv_t *pv_tmp = NULL;
   dir_cache_t *dir_cache = NULL;


#ifdef DEBUG
   debug ( "pv_status_all_pv_of_vg -- CALLED\n");
#endif
   if ( vg_name == NULL ||
        vg_check_name ( vg_name) < 0 ||
        pv == NULL) return -LVM_EPARAM;

   *pv = NULL;

   if ( strcmp ( vg_name, vg_name_sav) != 0) {
      strcpy ( vg_name_sav, vg_name);
      reread = TRUE;
   }

   if ( reread == TRUE) {
      if ( pv_this != NULL) {
         for ( p = 0; pv_this[p] != NULL; p++) free ( pv_this[p]);
         free ( pv_this);
         pv_this = NULL;
      }
      first = 0;
   }
   
   if ( first == 0) {
      if ( ( cache_size = lvm_dir_cache ( &dir_cache)) < 0)
         return -LVM_EPV_STATUS_ALL_PV_LVM_DIR_CACHE;

      np = 0;
      for ( n = 0; n < cache_size; n++) {
         pv_name = dir_cache[n].dev_name;

#ifdef DEBUG
         debug ( "pv_status_all_pv_of_vg -- calling pv_status "
                  "with %s  %s\n", vg_name, pv_name);
#endif

         if ( ( ret = pv_status ( vg_name, pv_name, &pv_tmp)) == 0) {
#ifdef DEBUG
            debug ( "pv_status_all_pv_of_vg -- pv_status is o.k. "
                    "--> allocating memory\n");
#endif
            pv_this_sav = pv_this;
            if ( ( pv_this = realloc ( pv_this,
                                       ( np+2) * sizeof ( pv_t*))) == NULL) {
               fprintf ( stderr, "realloc error in %s [line %d]\n",
                                 __FILE__, __LINE__);
               for ( p = 0; pv_this_sav[p] != NULL; p++)
                  free ( pv_this_sav[p]);
               return -LVM_EPV_STATUS_ALL_PV_OF_VG_MALLOC;
            }
            if ( ( pv_this[np] = malloc ( sizeof ( pv_t))) == NULL) {
               fprintf ( stderr, "malloc error in %s [line %d]\n",
                                 __FILE__, __LINE__);
               for ( p = 0; pv_this[p] != NULL; p++) free ( pv_this[p]);
               free ( pv_this);
               pv_this = NULL;
               return -LVM_EPV_STATUS_ALL_PV_OF_VG_MALLOC;
            }
            memcpy ( pv_this[np], pv_tmp, sizeof ( pv_t));
            np++;
            pv_this[np] = NULL;
         }
      }
      first = 1;
      if ( np == 0) return -LVM_EPV_STATUS_ALL_PV_OF_VG_NP;
   }

   *pv = pv_this;

#ifdef DEBUG
   debug ( "pv_status_all_pv_of_vg -- LEAVING\n");
#endif
   return 0;
}
