/*
 * tools/lib/pv_copy.c
 *
 * Copyright (C)  1998  Heinz Mauelshagen, Germany
 *
 * August 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

pv_t *pv_copy_from_disk ( pv_disk_t *pv_disk) {
   pv_t *pv_tmp = NULL;

#ifdef DEBUG
   debug ( "pv_copy_from_disk -- CALLED\n");
#endif
   if ( pv_disk != NULL && ( pv_tmp = malloc ( sizeof ( pv_t))) != NULL) {
      strncpy ( pv_tmp->id, pv_disk->id, sizeof ( pv_tmp->id));
      pv_tmp->version = LVM_TO_CORE32 ( pv_disk->version);
      pv_tmp->pv_on_disk.base = LVM_TO_CORE32 ( pv_disk->pv_on_disk.base);
      pv_tmp->pv_on_disk.size = LVM_TO_CORE32 ( pv_disk->pv_on_disk.size);
      pv_tmp->vg_on_disk.base = LVM_TO_CORE32 ( pv_disk->vg_on_disk.base);
      pv_tmp->vg_on_disk.size = LVM_TO_CORE32 ( pv_disk->vg_on_disk.size);
      pv_tmp->pv_namelist_on_disk.base =
         LVM_TO_CORE32 ( pv_disk->pv_namelist_on_disk.base);
      pv_tmp->pv_namelist_on_disk.size =
         LVM_TO_CORE32 ( pv_disk->pv_namelist_on_disk.size);
      pv_tmp->lv_on_disk.base = LVM_TO_CORE32 ( pv_disk->lv_on_disk.base);
      pv_tmp->lv_on_disk.size = LVM_TO_CORE32 ( pv_disk->lv_on_disk.size);
      pv_tmp->pe_on_disk.base = LVM_TO_CORE32 ( pv_disk->pe_on_disk.base);
      pv_tmp->pe_on_disk.size = LVM_TO_CORE32 ( pv_disk->pe_on_disk.size);
      strncpy ( pv_tmp->pv_name, pv_disk->pv_name, sizeof ( pv_tmp->pv_name));
      strncpy ( pv_tmp->vg_name, pv_disk->vg_name, sizeof ( pv_tmp->vg_name));
      strncpy ( pv_tmp->system_id, pv_disk->system_id,
                sizeof ( pv_tmp->system_id));
      pv_tmp->pv_dev = LVM_TO_CORE32 ( pv_disk->pv_major);
      pv_tmp->pv_number = LVM_TO_CORE32 ( pv_disk->pv_number);
      pv_tmp->pv_status = LVM_TO_CORE32 ( pv_disk->pv_status);
      pv_tmp->pv_allocatable = LVM_TO_CORE32 ( pv_disk->pv_allocatable);
      pv_tmp->pv_size = LVM_TO_CORE32 ( pv_disk->pv_size);
      pv_tmp->lv_cur = LVM_TO_CORE32 ( pv_disk->lv_cur);
      pv_tmp->pe_size = LVM_TO_CORE32 ( pv_disk->pe_size);
      pv_tmp->pe_total = LVM_TO_CORE32 ( pv_disk->pe_total);
      pv_tmp->pe_allocated = LVM_TO_CORE32 ( pv_disk->pe_allocated);
      pv_tmp->pe_stale = 0;
      pv_tmp->pe = NULL;
      pv_tmp->inode = NULL;
   }

#ifdef DEBUG
   debug ( "pv_copy_from_disk -- LEAVING\n");
#endif
   return pv_tmp;
}


pv_disk_t *pv_copy_to_disk ( pv_t *pv_core) {
   pv_disk_t *pv_tmp = NULL;

#ifdef DEBUG
   debug ( "pv_copy_to_disk -- CALLED\n");
#endif
   if ( pv_core != NULL &&  ( pv_tmp = malloc ( sizeof ( pv_disk_t))) != NULL) {
      strncpy ( pv_tmp->id, pv_core->id, sizeof ( pv_tmp->id));
      LVM_TO_DISK32 ( pv_tmp->version, pv_core->version);
      LVM_TO_DISK32 ( pv_tmp->pv_on_disk.base, pv_core->pv_on_disk.base);
      LVM_TO_DISK32 ( pv_tmp->pv_on_disk.size, pv_core->pv_on_disk.size);
      LVM_TO_DISK32 ( pv_tmp->vg_on_disk.base, pv_core->vg_on_disk.base);
      LVM_TO_DISK32 ( pv_tmp->vg_on_disk.size, pv_core->vg_on_disk.size);
      LVM_TO_DISK32 ( pv_tmp->pv_namelist_on_disk.base,
                      pv_core->pv_namelist_on_disk.base);
      LVM_TO_DISK32 ( pv_tmp->pv_namelist_on_disk.size,
                      pv_core->pv_namelist_on_disk.size);
      LVM_TO_DISK32 ( pv_tmp->lv_on_disk.base, pv_core->lv_on_disk.base);
      LVM_TO_DISK32 ( pv_tmp->lv_on_disk.size, pv_core->lv_on_disk.size);
      LVM_TO_DISK32 ( pv_tmp->pe_on_disk.base, pv_core->pe_on_disk.base);
      LVM_TO_DISK32 ( pv_tmp->pe_on_disk.size, pv_core->pe_on_disk.size);
      strncpy ( pv_tmp->pv_name, pv_core->pv_name, sizeof ( pv_tmp->pv_name));
      strncpy ( pv_tmp->vg_name, pv_core->vg_name, sizeof ( pv_tmp->vg_name));
      strncpy ( pv_tmp->system_id, pv_core->system_id,
                sizeof ( pv_tmp->system_id));
      /* core type is kdev_t; but no matter what it is,
         only store major for check in pv_read() */
      LVM_TO_DISK32 ( pv_tmp->pv_major, MAJOR ( pv_core->pv_dev));
      LVM_TO_DISK32 ( pv_tmp->pv_number, pv_core->pv_number);
      LVM_TO_DISK32 ( pv_tmp->pv_status, pv_core->pv_status);
      LVM_TO_DISK32 ( pv_tmp->pv_allocatable, pv_core->pv_allocatable);
      LVM_TO_DISK32 ( pv_tmp->pv_size, pv_core->pv_size);
      LVM_TO_DISK32 ( pv_tmp->lv_cur, pv_core->lv_cur);
      LVM_TO_DISK32 ( pv_tmp->pe_size, pv_core->pe_size);
      LVM_TO_DISK32 ( pv_tmp->pe_total, pv_core->pe_total);
      LVM_TO_DISK32 ( pv_tmp->pe_allocated, pv_core->pe_allocated);
      pv_tmp->dummy1 = \
      pv_tmp->dummy2 = \
      pv_tmp->dummy3 = 0;
   }

#ifdef DEBUG
   debug ( "pv_copy_to_disk -- LEAVING\n");
#endif
   return pv_tmp;
}
