/*
 * tools/lib/pv_check_part.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March,October,November 1997
 * January 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    10/08/1997 - changed partition number to absolute
 *    11/07/1997 - added debug info
 *    01/23/1999 - extension for devfs names
 *
 */

#include <liblvm.h>

int pv_check_part ( char *dev_name) {
   int i = 0;
   int ret = 0;
   char *part_ptr = NULL;

#ifdef DEBUG
   debug ( "pv_check_part -- CALLED with %s\n", dev_name);
#endif

   if ( dev_name == NULL || pv_check_name ( dev_name) < 0) ret = -LVM_EPARAM;
   else {
      part_ptr = dev_name + ( i = strlen ( dev_name)) - 1;
      for ( ; i > 0; i--) {
         if ( !isdigit ( *part_ptr)) break;
         part_ptr--;
      }
      part_ptr++;
      ret = atoi ( part_ptr);
      if ( ret < MIN_PART || ret > MAX_PART) ret = -LVM_EPV_CHECK_PART;
   }

#ifdef DEBUG
   debug ( "pv_check_part -- LEAVING with %d\n", ret);
#endif
   return ret;
}
