/*
 * tools/lib/lv_get_index.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * April,October 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    10/16/97 - renamed function to lv_get_index_ba_name
 *             - changed formal paramter sequence analog pv_get_index_...
 *             - implemented lv_get_index_by_kdev_t
 *
 */

#include <liblvm.h>

int lv_get_index_by_kdev_t ( vg_t *vg, kdev_t dev) {
   int l = 0;
   int ret = -1;

#ifdef DEBUG
   debug ( "lv_get_index_by_kdev_t -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0) return -LVM_EPARAM;

   for ( l = 0; l < vg->lv_max; l++) {
      if ( vg->lv[l] != NULL && vg->lv[l]->lv_dev == dev) {
         ret = l;
         break;
      }
   }

#ifdef DEBUG
   debug ( "lv_get_index_by_kdev_t -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}


int lv_get_index_by_name ( vg_t *vg, char *lv_name) {
   int l = 0;
   int ret = -1;

#ifdef DEBUG
   debug ( "lv_get_index_by_name -- CALLED\n");
#endif

   if ( lv_name == NULL || lv_check_name ( lv_name) < 0 ||
        vg == NULL || vg_check_name ( vg->vg_name) < 0) return -LVM_EPARAM;

   for ( l = 0; l < vg->lv_max; l++) {
      if ( vg->lv[l] != NULL && 
           strcmp ( vg->lv[l]->lv_name, lv_name) == 0) {
         ret = l;
         break;
      }
   }

#ifdef DEBUG
   debug ( "lv_get_index_by_name -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
