/*
 * tools/lib/lv_create_node.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * May 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    01/11/1998 - added unlink() on logical volume special file
 *    04/29/1998 - added vg_number, lv_number usage to get
 *                 seperation from LV name
 *               - changed to new lv_create_kdev_t()
 *    07/27/1998 - enhanced error check
 *
 */

#include <liblvm.h>

int lv_create_node ( char *lv_name,
                     unsigned long vg_number,
                     unsigned long lv_number) {
   int ret = 0;

#ifdef DEBUG
   debug ( "lv_create_node -- CALLED\n");
#endif

   if ( lv_name == NULL || lv_check_name ( lv_name) < 0 ||
        vg_number < 0 || vg_number > MAX_VG ||
        lv_number < 1 || lv_number > MAX_LV) {
      ret = -LVM_EPARAM;
      goto lv_create_node_end;
   }

   if ( unlink ( lv_name) == -1) {
      if ( errno != ENOENT) {
         ret = -LVM_ELV_CREATE_NODE_UNLINK;
         goto lv_create_node_end;
      }
   }

   if ( mknod ( lv_name, S_IFBLK | S_IRUSR | S_IWUSR | S_IRGRP,
                lv_create_kdev_t ( vg_number, lv_number)) == -1)
      ret = -LVM_ELV_CREATE_MODE_MKNOD;
   else if ( chmod ( lv_name, 0640) == -1) ret = -LVM_ELV_CREATE_MODE_CHMOD;

lv_create_node_end:
#ifdef DEBUG
   debug ( "lv_create_node -- LEAVING with %d\n", ret);
#endif
   return ret;
}
