/*
 * tools/lib/lv_check_name.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March 1997
 * January,September 1998
 * January 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    01/11/1998 - added checks on logical volume name
 *    04/30/1998 - avoided logical volume name = "group"
 *    01/05/1998 - enhanced name checking
 *    09/06/1998 - checked LV name with new lvm_check_chars()
 *    01/26/1999 - made volume group directory prefix a preprocessor option
 *
 */

#include <liblvm.h>

int lv_check_name ( char *lv_name) {
   int length = 0;
   char *lv_part = NULL;
   char *vg_part = NULL;
   char lv_name_this[NAME_LEN];

#ifdef DEBUG
   debug ( "lv_check_name -- CALLED\n");
#endif

   if ( lv_name == NULL ) return -LVM_EPARAM;

#ifdef DEBUG
   debug ( "lv_check_name -- lv_name: \"%s\"\n", lv_name);
#endif

   if ( lvm_check_chars ( lv_name) < 0) return -LVM_ELV_CHECK_NAME_LV_NAME;
   if ( strlen ( lv_name) > ( NAME_LEN - 1)) return -LVM_ELV_CHECK_NAME_LV_NAME;
   if ( *lv_name == 0) return -LVM_ELV_CHECK_NAME_LV_NAME;

   if ( strchr ( lv_name, '/') != NULL) {
      strcpy ( lv_name_this, lv_name);
      length = strlen ( LVM_DIR_PREFIX);
      if ( strncmp ( lv_name_this, LVM_DIR_PREFIX, length) != 0)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
      vg_part = &lv_name_this[length];
      if ( ( lv_part = strchr ( vg_part, '/')) == NULL)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
      *lv_part++ = 0;
      if ( strchr ( lv_part, '/') != NULL)
         return -LVM_ELV_CHECK_NAME_LV_NAME;
      if ( vg_check_name ( vg_part) < 0)
         return -LVM_ELV_CHECK_NAME_VG_NAME;
   } else lv_part = lv_name;

   if ( strcmp ( lv_part, "group") == 0) return -LVM_ELV_CHECK_NAME_LV_NAME;

#ifdef DEBUG
   debug ( "lv_check_name -- LEAVING with ret: 0\n");
#endif
   return 0;
}
