/*
 * tools/lib/lv_change_vgname.c
 *
 * Copyright (C) 1997 - 1998  Heinz Mauelshagen, Germany
 *
 * May 1997
 * June 1998
 * January 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 *
 * Changelog
 *
 *    06/12/1998 - added debug return output
 *
 */

#include <liblvm.h>

char *lv_change_vgname ( char *vg_name, char *lv_name) {
   char *lv_name_ptr = NULL;
   char *ret = NULL;
   static char lv_name_buf[NAME_LEN] = { 0, };

#ifdef DEBUG
   debug ( "lv_change_vgname -- CALLED\n");
#endif

   if ( vg_name == NULL || vg_check_name ( vg_name) < 0 ||
        lv_name == NULL || lv_check_name ( lv_name) < 0) {
      ret = NULL;
   } else {
      lv_name_ptr = strrchr ( lv_name, '/');
      lv_name_ptr++;
      sprintf ( lv_name_buf, LVM_DIR_PREFIX "%s/%s%c", vg_name, lv_name_ptr, 0);
      ret = lv_name_buf;
   }

#ifdef DEBUG
   debug ( "lv_change_vgname -- LEAVING with ret: %s\n", ret);
#endif
   return ret;
}
