/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 * May,June 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/09/1998 - added showing volume group extendability
 *    06/14/1998 - changed display order in vg_show_with_pv_and_lv()
 *
 */

#include <liblvm.h>

void vg_show ( vg_t *vg) {
   char *dummy = NULL;

#ifdef DEBUG
   debug ( "vg_show -- CALLED\n");
#endif

   if ( vg == NULL || vg_check_name ( vg->vg_name) < 0) return;

   printf ( "--- Volume group ---\n");
   printf ( "VG Name               %s\n", vg->vg_name);
   printf ( "VG Write Access       ");
   if ( vg->vg_access == ( VG_READ | VG_WRITE)) printf ( "read/write\n");
   else                                         printf ( "read\n");
   printf ( "VG Status             ");
   if ( ! ( vg->vg_status & VG_ACTIVE)) printf ( "NOT ");
   printf ( "available");
   if ( vg->vg_status & VG_EXPORTED) printf ( "/exported");
   printf ( "/");
   if ( ! ( vg->vg_status & VG_EXTENDABLE)) printf ( "NOT ");
   printf ( "resizable\n");
   printf ( "VG #                  %u\n", vg->vg_number);
   printf ( "MAX LV                %u\n", vg->lv_max);
   printf ( "Cur LV                %u\n", vg->lv_cur);
   printf ( "Open LV               %u\n", vg->lv_open);
   printf ( "MAX LV Size           %s\n",
            ( dummy = lvm_show_size ( LVM_LV_SIZE_MAX(vg) / 2, SHORT)));
   free ( dummy);
   printf ( "Max PV                %u\n", vg->pv_max);
   printf ( "Cur PV                %u\n", vg->pv_cur);
   printf ( "Act PV                %u\n", vg->pv_act);

#ifdef LVM_FUTURE
   printf ( "VGDA                  %u\n", vg->vgda);
#endif
   printf ( "VG Size               %s\n",
            ( dummy = lvm_show_size ( vg->pe_total * vg->pe_size / 2, SHORT)));
   free ( dummy);
   printf ( "PE Size               %s\n",
            ( dummy = lvm_show_size ( vg->pe_size / 2, SHORT)));
   free ( dummy);
   printf ( "Total PE              %u\n", vg->pe_total);
   printf ( "Alloc PE / Size       %u / %s\n",
            vg->pe_allocated,
            ( dummy = lvm_show_size ( vg->pe_allocated * vg->pe_size / 2, SHORT)));
   free ( dummy);
   printf ( "Free  PE / Size       %u / %s\n",
            vg->pe_total - vg->pe_allocated,
            ( dummy = lvm_show_size ( ( vg->pe_total - vg->pe_allocated) *
                                   vg->pe_size / 2, SHORT)));
   free ( dummy);
#ifdef LVM_FUTURE
   printf ( "Total PVG             %u\n", vg->pvg_total);
#endif

#ifdef DEBUG
   debug ( "vg_show -- LEAVING\n");
#endif
   return;
}


void vg_show_with_pv_and_lv ( vg_t *vg) {
#ifdef DEBUG
   debug ( "vg_show_with_pv_and_lv -- CALLED\n");
#endif

   vg_show ( vg);
   printf ( "\n");
   lv_show_all_lv_of_vg ( vg);
   printf ( "\n");
   pv_show_all_pv_of_vg ( vg);

#ifdef DEBUG
   debug ( "vg_show_with_pv_and_lv -- LEAVING\n");
#endif
   return;
}
