/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March-May 1997
 * January 1998
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    01/11/1998 - seperated from previous vg_name.c
 *    05/01/1998 - supported free logical volume and volume group names
 *
 */

#include <liblvm.h>

char *vg_name_of_lv ( char *lv_name) {
   char *vg_part = NULL;
   char *vg_part_end = NULL;
   static char lv_name_this[NAME_LEN];

#ifdef DEBUG
   debug ( "vg_name_of_lv -- CALLED\n");
#endif

   if ( lv_name == NULL || lv_check_name ( lv_name) < 0) return NULL;

   strcpy ( lv_name_this, lv_name);
   vg_part = &lv_name_this[5];
   if ( ( vg_part_end = strrchr ( vg_part, '/')) == NULL) return NULL;
   *vg_part_end = 0;
   if ( vg_check_name ( vg_part) < 0) return NULL;

#ifdef DEBUG
   debug ( "vg_name_of_lv -- LEAVING\n");
#endif
   return vg_part;
}
