/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>


int pv_setup_for_create ( char *dev_name, pv_t *pv, uint size) {
#ifdef DEBUG
   debug ( "pv_setup_for_create -- CALLED\n");
#endif

   if ( dev_name == NULL ||
        pv_check_name ( dev_name) < 0 ||
        pv == NULL ||
        size == 0) return -LVM_EPARAM;

   strncpy ( pv->id, LVM_ID, sizeof ( pv->id));
   pv->version = LVM_STRUCT_VERSION;
   pv->pv_on_disk.base = LVM_PV_DISK_BASE;
   pv->pv_on_disk.size = LVM_PV_DISK_SIZE;
   pv->vg_on_disk.base = 0;
   pv->vg_on_disk.size = 0;
   pv->pv_namelist_on_disk.base = 0;
   pv->pv_namelist_on_disk.size = 0;
   pv->lv_on_disk.base = 0;
   pv->lv_on_disk.size = 0;
   pv->pe_on_disk.base = 0;
   pv->pe_on_disk.size = 0;
   strcpy ( pv->pv_name, dev_name);
   pv->vg_name[0] = 0;
   system_id_set ( pv->system_id);
   pv->pv_dev = pv_create_kdev_t ( dev_name);
   pv->pv_number = 0;
   pv->pv_status = 0; /* bitfield */
   pv->pv_allocatable = PV_ALLOCATABLE; /* bitfield */
   pv->pv_size = size;
   pv->lv_cur = 0;
   pv->pe_size = 0;
   pv->pe_total = 0;
   pv->pe_allocated = 0;
   pv->pe_stale = 0;
   pv->pe = 0;
   pv->inode = NULL;

#ifdef DEBUG
   debug ( "pv_setup_for_create -- LEAVING\n");
#endif
   return 0;
}
