/*
 * Author: Heinz Mauelshagen, Germany
 *
 * October 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int pv_flush ( char *pv_name) {
   int lvm = -1;
   int ret = 0;
   pv_flush_req_t req;

#ifdef DEBUG
   debug ( "pv_flush -- CALLED to flush %s\n", pv_name);
#endif

   if ( pv_name == NULL || pv_check_name ( pv_name) < 0) return -LVM_EPARAM;

   strcpy ( req.pv_name, pv_name);
   if ( ( lvm = open ( LVM_DEV, O_RDONLY)) == -1)
      ret = -LVM_EPV_FLUSH_OPEN;
   else ret = ioctl ( lvm, PV_FLUSH, &req);

   if ( ret == -1) ret = -errno;

   if ( lvm != -1) close ( lvm);

#ifdef DEBUG
   debug ( "pv_flush -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
