/*
 * Author: Heinz Mauelshagen, Germany
 *
 * May,November 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    11/11/97 - avoided generating vgNN names in algorithm
 *
 */

#include <liblvm.h>

int pv_find_vg ( char *pv_name, char **vg_name) {
   int ret = FALSE;
   int v = 0;
   char **vg_name_ptr = NULL;

#ifdef DEBUG
   debug ( "pv_find_vg -- CALLED\n");
#endif

   if ( pv_name == NULL || pv_check_name ( pv_name) < 0 ||
        vg_name == NULL) return -LVM_EPARAM;

   *vg_name = NULL;

   if ( ( vg_name_ptr = vg_check_active_all_vg ()) != NULL) {
      for ( v = 0; vg_name_ptr[v] != NULL; v++) {
         if ( pv_check_active ( vg_name_ptr[v], pv_name) == TRUE) {
#ifdef DEBUG
         debug ( "pv_find_vg -- HIT %s\n", vg_name_ptr[v]);
#endif
            *vg_name = vg_name_ptr[v];
            ret = TRUE;
            break;
         }
      }
   } else ret = FALSE;

#ifdef DEBUG
   debug ( "pv_find_vg -- LEAVING  ret: %d  *vg_name: \"%s\"\n",
            ret, *vg_name);
#endif
   return ret;
}
