/*
 * Author: Heinz Mauelshagen, Germany
 *
 * May 1997
 * June 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    06/14/1998 -- used pv_get_index_by_name() instead of own loop
 *
 */

#include <liblvm.h>

int pv_check_in_vg ( vg_t *vg, char *pv_name) {
   int ret = FALSE;

#ifdef DEBUG
   debug ( "pv_check_in_vg -- CALLED\n");
#endif

   if ( vg == NULL || pv_name == NULL ||
        vg_check_name ( vg->vg_name) < 0 ||
        pv_check_name ( pv_name) < 0) return -LVM_EPARAM;

   if ( pv_get_index_by_name ( vg, pv_name) > -1 ) ret = TRUE;
   
#ifdef DEBUG
   debug ( "pv_check_in_vg -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
