/*
 * Author: Heinz Mauelshagen, Germany
 *
 * June 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

static int lock = -1;

int lvm_lock ( void) {
   if ( lock > -1) return -LVM_ELVM_LOCK_YET_LOCKED;
   if ( ( lock = open ( LVM_DEV, O_RDONLY)) == -1) return -errno;
   
   return 0;
}


int lvm_unlock ( void) {
   if ( lock == -1) return -LVM_ELVM_UNLOCK;
   close ( lock);
   lock = 0;

   return 0;
}
